/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.api.platform.models.CreditRevocation;
import net.accelbyte.sdk.api.platform.models.EntitlementRevocation;
import net.accelbyte.sdk.api.platform.models.ItemRevocation;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RevocationResult
extends Model {
    @JsonProperty(value="creditRevocations")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<CreditRevocation> creditRevocations;
    @JsonProperty(value="entitlementRevocations")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<EntitlementRevocation> entitlementRevocations;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="itemRevocations")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<ItemRevocation> itemRevocations;
    @JsonProperty(value="status")
    private String status;

    @JsonIgnore
    public String getStatus() {
        return this.status;
    }

    @JsonIgnore
    public Status getStatusAsEnum() {
        return Status.valueOf(this.status);
    }

    @JsonIgnore
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonIgnore
    public void setStatusFromEnum(Status status) {
        this.status = status.toString();
    }

    @JsonIgnore
    public RevocationResult createFromJson(String json) throws JsonProcessingException {
        return (RevocationResult)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<RevocationResult> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<RevocationResult>>(){});
    }

    public static RevocationResultBuilder builder() {
        return new RevocationResultBuilder();
    }

    public List<CreditRevocation> getCreditRevocations() {
        return this.creditRevocations;
    }

    public List<EntitlementRevocation> getEntitlementRevocations() {
        return this.entitlementRevocations;
    }

    public String getId() {
        return this.id;
    }

    public List<ItemRevocation> getItemRevocations() {
        return this.itemRevocations;
    }

    @JsonProperty(value="creditRevocations")
    public void setCreditRevocations(List<CreditRevocation> creditRevocations) {
        this.creditRevocations = creditRevocations;
    }

    @JsonProperty(value="entitlementRevocations")
    public void setEntitlementRevocations(List<EntitlementRevocation> entitlementRevocations) {
        this.entitlementRevocations = entitlementRevocations;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="itemRevocations")
    public void setItemRevocations(List<ItemRevocation> itemRevocations) {
        this.itemRevocations = itemRevocations;
    }

    @Deprecated
    public RevocationResult(List<CreditRevocation> creditRevocations, List<EntitlementRevocation> entitlementRevocations, String id, List<ItemRevocation> itemRevocations, String status) {
        this.creditRevocations = creditRevocations;
        this.entitlementRevocations = entitlementRevocations;
        this.id = id;
        this.itemRevocations = itemRevocations;
        this.status = status;
    }

    public RevocationResult() {
    }

    public static class RevocationResultBuilder {
        private List<CreditRevocation> creditRevocations;
        private List<EntitlementRevocation> entitlementRevocations;
        private String id;
        private List<ItemRevocation> itemRevocations;
        private String status;

        public RevocationResultBuilder status(String status) {
            this.status = status;
            return this;
        }

        public RevocationResultBuilder statusFromEnum(Status status) {
            this.status = status.toString();
            return this;
        }

        RevocationResultBuilder() {
        }

        @JsonProperty(value="creditRevocations")
        public RevocationResultBuilder creditRevocations(List<CreditRevocation> creditRevocations) {
            this.creditRevocations = creditRevocations;
            return this;
        }

        @JsonProperty(value="entitlementRevocations")
        public RevocationResultBuilder entitlementRevocations(List<EntitlementRevocation> entitlementRevocations) {
            this.entitlementRevocations = entitlementRevocations;
            return this;
        }

        @JsonProperty(value="id")
        public RevocationResultBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="itemRevocations")
        public RevocationResultBuilder itemRevocations(List<ItemRevocation> itemRevocations) {
            this.itemRevocations = itemRevocations;
            return this;
        }

        public RevocationResult build() {
            return new RevocationResult(this.creditRevocations, this.entitlementRevocations, this.id, this.itemRevocations, this.status);
        }

        public String toString() {
            return "RevocationResult.RevocationResultBuilder(creditRevocations=" + this.creditRevocations + ", entitlementRevocations=" + this.entitlementRevocations + ", id=" + this.id + ", itemRevocations=" + this.itemRevocations + ", status=" + this.status + ")";
        }
    }

    public static enum Status {
        FAIL("FAIL"),
        SUCCESS("SUCCESS");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

