/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.api.platform.models.BaseTLSConfig;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PublicCustomConfigInfo
extends Model {
    @JsonProperty(value="connectionType")
    private String connectionType;
    @JsonProperty(value="grpcServerAddress")
    private String grpcServerAddress;
    @JsonProperty(value="tlsConfig")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private BaseTLSConfig tlsConfig;

    @JsonIgnore
    public String getConnectionType() {
        return this.connectionType;
    }

    @JsonIgnore
    public ConnectionType getConnectionTypeAsEnum() {
        return ConnectionType.valueOf(this.connectionType);
    }

    @JsonIgnore
    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    @JsonIgnore
    public void setConnectionTypeFromEnum(ConnectionType connectionType) {
        this.connectionType = connectionType.toString();
    }

    @JsonIgnore
    public PublicCustomConfigInfo createFromJson(String json) throws JsonProcessingException {
        return (PublicCustomConfigInfo)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<PublicCustomConfigInfo> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<PublicCustomConfigInfo>>(){});
    }

    public static PublicCustomConfigInfoBuilder builder() {
        return new PublicCustomConfigInfoBuilder();
    }

    public String getGrpcServerAddress() {
        return this.grpcServerAddress;
    }

    public BaseTLSConfig getTlsConfig() {
        return this.tlsConfig;
    }

    @JsonProperty(value="grpcServerAddress")
    public void setGrpcServerAddress(String grpcServerAddress) {
        this.grpcServerAddress = grpcServerAddress;
    }

    @JsonProperty(value="tlsConfig")
    public void setTlsConfig(BaseTLSConfig tlsConfig) {
        this.tlsConfig = tlsConfig;
    }

    @Deprecated
    public PublicCustomConfigInfo(String connectionType, String grpcServerAddress, BaseTLSConfig tlsConfig) {
        this.connectionType = connectionType;
        this.grpcServerAddress = grpcServerAddress;
        this.tlsConfig = tlsConfig;
    }

    public PublicCustomConfigInfo() {
    }

    public static class PublicCustomConfigInfoBuilder {
        private String grpcServerAddress;
        private BaseTLSConfig tlsConfig;
        private String connectionType;

        public PublicCustomConfigInfoBuilder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        public PublicCustomConfigInfoBuilder connectionTypeFromEnum(ConnectionType connectionType) {
            this.connectionType = connectionType.toString();
            return this;
        }

        PublicCustomConfigInfoBuilder() {
        }

        @JsonProperty(value="grpcServerAddress")
        public PublicCustomConfigInfoBuilder grpcServerAddress(String grpcServerAddress) {
            this.grpcServerAddress = grpcServerAddress;
            return this;
        }

        @JsonProperty(value="tlsConfig")
        public PublicCustomConfigInfoBuilder tlsConfig(BaseTLSConfig tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        public PublicCustomConfigInfo build() {
            return new PublicCustomConfigInfo(this.connectionType, this.grpcServerAddress, this.tlsConfig);
        }

        public String toString() {
            return "PublicCustomConfigInfo.PublicCustomConfigInfoBuilder(connectionType=" + this.connectionType + ", grpcServerAddress=" + this.grpcServerAddress + ", tlsConfig=" + (Object)((Object)this.tlsConfig) + ")";
        }
    }

    public static enum ConnectionType {
        INSECURE("INSECURE"),
        TLS("TLS");

        private String value;

        private ConnectionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

