/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Predicate
extends Model {
    @JsonProperty(value="anyOf")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer anyOf;
    @JsonProperty(value="comparison")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String comparison;
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String name;
    @JsonProperty(value="predicateType")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String predicateType;
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String value;
    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> values;

    @JsonIgnore
    public String getComparison() {
        return this.comparison;
    }

    @JsonIgnore
    public Comparison getComparisonAsEnum() {
        return Comparison.valueOf(this.comparison);
    }

    @JsonIgnore
    public void setComparison(String comparison) {
        this.comparison = comparison;
    }

    @JsonIgnore
    public void setComparisonFromEnum(Comparison comparison) {
        this.comparison = comparison.toString();
    }

    @JsonIgnore
    public String getPredicateType() {
        return this.predicateType;
    }

    @JsonIgnore
    public PredicateType getPredicateTypeAsEnum() {
        return PredicateType.valueOf(this.predicateType);
    }

    @JsonIgnore
    public void setPredicateType(String predicateType) {
        this.predicateType = predicateType;
    }

    @JsonIgnore
    public void setPredicateTypeFromEnum(PredicateType predicateType) {
        this.predicateType = predicateType.toString();
    }

    @JsonIgnore
    public Predicate createFromJson(String json) throws JsonProcessingException {
        return (Predicate)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<Predicate> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<Predicate>>(){});
    }

    public static PredicateBuilder builder() {
        return new PredicateBuilder();
    }

    public Integer getAnyOf() {
        return this.anyOf;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public List<String> getValues() {
        return this.values;
    }

    @JsonProperty(value="anyOf")
    public void setAnyOf(Integer anyOf) {
        this.anyOf = anyOf;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="value")
    public void setValue(String value) {
        this.value = value;
    }

    @JsonProperty(value="values")
    public void setValues(List<String> values) {
        this.values = values;
    }

    @Deprecated
    public Predicate(Integer anyOf, String comparison, String name, String predicateType, String value, List<String> values) {
        this.anyOf = anyOf;
        this.comparison = comparison;
        this.name = name;
        this.predicateType = predicateType;
        this.value = value;
        this.values = values;
    }

    public Predicate() {
    }

    public static class PredicateBuilder {
        private Integer anyOf;
        private String name;
        private String value;
        private List<String> values;
        private String comparison;
        private String predicateType;

        public PredicateBuilder comparison(String comparison) {
            this.comparison = comparison;
            return this;
        }

        public PredicateBuilder comparisonFromEnum(Comparison comparison) {
            this.comparison = comparison.toString();
            return this;
        }

        public PredicateBuilder predicateType(String predicateType) {
            this.predicateType = predicateType;
            return this;
        }

        public PredicateBuilder predicateTypeFromEnum(PredicateType predicateType) {
            this.predicateType = predicateType.toString();
            return this;
        }

        PredicateBuilder() {
        }

        @JsonProperty(value="anyOf")
        public PredicateBuilder anyOf(Integer anyOf) {
            this.anyOf = anyOf;
            return this;
        }

        @JsonProperty(value="name")
        public PredicateBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="value")
        public PredicateBuilder value(String value) {
            this.value = value;
            return this;
        }

        @JsonProperty(value="values")
        public PredicateBuilder values(List<String> values) {
            this.values = values;
            return this;
        }

        public Predicate build() {
            return new Predicate(this.anyOf, this.comparison, this.name, this.predicateType, this.value, this.values);
        }

        public String toString() {
            return "Predicate.PredicateBuilder(anyOf=" + this.anyOf + ", comparison=" + this.comparison + ", name=" + this.name + ", predicateType=" + this.predicateType + ", value=" + this.value + ", values=" + this.values + ")";
        }
    }

    public static enum PredicateType {
        EntitlementPredicate("EntitlementPredicate"),
        SeasonPassPredicate("SeasonPassPredicate"),
        SeasonTierPredicate("SeasonTierPredicate");

        private String value;

        private PredicateType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Comparison {
        Excludes("excludes"),
        Includes("includes"),
        Is("is"),
        IsGreaterThan("isGreaterThan"),
        IsGreaterThanOrEqual("isGreaterThanOrEqual"),
        IsLessThan("isLessThan"),
        IsLessThanOrEqual("isLessThanOrEqual"),
        IsNot("isNot");

        private String value;

        private Comparison(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

