/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PlatformDlcEntry
extends Model {
    @JsonProperty(value="platform")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String platform;
    @JsonProperty(value="platformDlcIdMap")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, String> platformDlcIdMap;

    @JsonIgnore
    public String getPlatform() {
        return this.platform;
    }

    @JsonIgnore
    public Platform getPlatformAsEnum() {
        return Platform.valueOf(this.platform);
    }

    @JsonIgnore
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @JsonIgnore
    public void setPlatformFromEnum(Platform platform) {
        this.platform = platform.toString();
    }

    @JsonIgnore
    public PlatformDlcEntry createFromJson(String json) throws JsonProcessingException {
        return (PlatformDlcEntry)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<PlatformDlcEntry> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<PlatformDlcEntry>>(){});
    }

    public static PlatformDlcEntryBuilder builder() {
        return new PlatformDlcEntryBuilder();
    }

    public Map<String, String> getPlatformDlcIdMap() {
        return this.platformDlcIdMap;
    }

    @JsonProperty(value="platformDlcIdMap")
    public void setPlatformDlcIdMap(Map<String, String> platformDlcIdMap) {
        this.platformDlcIdMap = platformDlcIdMap;
    }

    @Deprecated
    public PlatformDlcEntry(String platform, Map<String, String> platformDlcIdMap) {
        this.platform = platform;
        this.platformDlcIdMap = platformDlcIdMap;
    }

    public PlatformDlcEntry() {
    }

    public static class PlatformDlcEntryBuilder {
        private Map<String, String> platformDlcIdMap;
        private String platform;

        public PlatformDlcEntryBuilder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public PlatformDlcEntryBuilder platformFromEnum(Platform platform) {
            this.platform = platform.toString();
            return this;
        }

        PlatformDlcEntryBuilder() {
        }

        @JsonProperty(value="platformDlcIdMap")
        public PlatformDlcEntryBuilder platformDlcIdMap(Map<String, String> platformDlcIdMap) {
            this.platformDlcIdMap = platformDlcIdMap;
            return this;
        }

        public PlatformDlcEntry build() {
            return new PlatformDlcEntry(this.platform, this.platformDlcIdMap);
        }

        public String toString() {
            return "PlatformDlcEntry.PlatformDlcEntryBuilder(platform=" + this.platform + ", platformDlcIdMap=" + this.platformDlcIdMap + ")";
        }
    }

    public static enum Platform {
        EPICGAMES("EPICGAMES"),
        OCULUS("OCULUS"),
        PSN("PSN"),
        STEAM("STEAM"),
        XBOX("XBOX");

        private String value;

        private Platform(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

