/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PaymentUrl
extends Model {
    @JsonProperty(value="paymentProvider")
    private String paymentProvider;
    @JsonProperty(value="paymentType")
    private String paymentType;
    @JsonProperty(value="paymentUrl")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String paymentUrl;
    @JsonProperty(value="returnUrl")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String returnUrl;
    @JsonProperty(value="sessionData")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String sessionData;
    @JsonProperty(value="sessionId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String sessionId;

    @JsonIgnore
    public String getPaymentProvider() {
        return this.paymentProvider;
    }

    @JsonIgnore
    public PaymentProvider getPaymentProviderAsEnum() {
        return PaymentProvider.valueOf(this.paymentProvider);
    }

    @JsonIgnore
    public void setPaymentProvider(String paymentProvider) {
        this.paymentProvider = paymentProvider;
    }

    @JsonIgnore
    public void setPaymentProviderFromEnum(PaymentProvider paymentProvider) {
        this.paymentProvider = paymentProvider.toString();
    }

    @JsonIgnore
    public String getPaymentType() {
        return this.paymentType;
    }

    @JsonIgnore
    public PaymentType getPaymentTypeAsEnum() {
        return PaymentType.valueOf(this.paymentType);
    }

    @JsonIgnore
    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    @JsonIgnore
    public void setPaymentTypeFromEnum(PaymentType paymentType) {
        this.paymentType = paymentType.toString();
    }

    @JsonIgnore
    public PaymentUrl createFromJson(String json) throws JsonProcessingException {
        return (PaymentUrl)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<PaymentUrl> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<PaymentUrl>>(){});
    }

    public static PaymentUrlBuilder builder() {
        return new PaymentUrlBuilder();
    }

    public String getPaymentUrl() {
        return this.paymentUrl;
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public String getSessionData() {
        return this.sessionData;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    @JsonProperty(value="paymentUrl")
    public void setPaymentUrl(String paymentUrl) {
        this.paymentUrl = paymentUrl;
    }

    @JsonProperty(value="returnUrl")
    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    @JsonProperty(value="sessionData")
    public void setSessionData(String sessionData) {
        this.sessionData = sessionData;
    }

    @JsonProperty(value="sessionId")
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Deprecated
    public PaymentUrl(String paymentProvider, String paymentType, String paymentUrl, String returnUrl, String sessionData, String sessionId) {
        this.paymentProvider = paymentProvider;
        this.paymentType = paymentType;
        this.paymentUrl = paymentUrl;
        this.returnUrl = returnUrl;
        this.sessionData = sessionData;
        this.sessionId = sessionId;
    }

    public PaymentUrl() {
    }

    public static class PaymentUrlBuilder {
        private String paymentUrl;
        private String returnUrl;
        private String sessionData;
        private String sessionId;
        private String paymentProvider;
        private String paymentType;

        public PaymentUrlBuilder paymentProvider(String paymentProvider) {
            this.paymentProvider = paymentProvider;
            return this;
        }

        public PaymentUrlBuilder paymentProviderFromEnum(PaymentProvider paymentProvider) {
            this.paymentProvider = paymentProvider.toString();
            return this;
        }

        public PaymentUrlBuilder paymentType(String paymentType) {
            this.paymentType = paymentType;
            return this;
        }

        public PaymentUrlBuilder paymentTypeFromEnum(PaymentType paymentType) {
            this.paymentType = paymentType.toString();
            return this;
        }

        PaymentUrlBuilder() {
        }

        @JsonProperty(value="paymentUrl")
        public PaymentUrlBuilder paymentUrl(String paymentUrl) {
            this.paymentUrl = paymentUrl;
            return this;
        }

        @JsonProperty(value="returnUrl")
        public PaymentUrlBuilder returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        @JsonProperty(value="sessionData")
        public PaymentUrlBuilder sessionData(String sessionData) {
            this.sessionData = sessionData;
            return this;
        }

        @JsonProperty(value="sessionId")
        public PaymentUrlBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public PaymentUrl build() {
            return new PaymentUrl(this.paymentProvider, this.paymentType, this.paymentUrl, this.returnUrl, this.sessionData, this.sessionId);
        }

        public String toString() {
            return "PaymentUrl.PaymentUrlBuilder(paymentProvider=" + this.paymentProvider + ", paymentType=" + this.paymentType + ", paymentUrl=" + this.paymentUrl + ", returnUrl=" + this.returnUrl + ", sessionData=" + this.sessionData + ", sessionId=" + this.sessionId + ")";
        }
    }

    public static enum PaymentType {
        LINK("LINK"),
        QRCODE("QR_CODE");

        private String value;

        private PaymentType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum PaymentProvider {
        ADYEN("ADYEN"),
        ALIPAY("ALIPAY"),
        CHECKOUT("CHECKOUT"),
        PAYPAL("PAYPAL"),
        STRIPE("STRIPE"),
        WALLET("WALLET"),
        WXPAY("WXPAY"),
        XSOLLA("XSOLLA");

        private String value;

        private PaymentProvider(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

