/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PaymentProviderConfigInfo
extends Model {
    @JsonProperty(value="aggregate")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String aggregate;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="namespace")
    private String namespace;
    @JsonProperty(value="paymentMerchantConfigId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String paymentMerchantConfigId;
    @JsonProperty(value="region")
    private String region;
    @JsonProperty(value="sandboxTaxJarApiToken")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String sandboxTaxJarApiToken;
    @JsonProperty(value="specials")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> specials;
    @JsonProperty(value="taxJarApiToken")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String taxJarApiToken;
    @JsonProperty(value="taxJarEnabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean taxJarEnabled;
    @JsonProperty(value="useGlobalTaxJarApiToken")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean useGlobalTaxJarApiToken;

    @JsonIgnore
    public String getAggregate() {
        return this.aggregate;
    }

    @JsonIgnore
    public Aggregate getAggregateAsEnum() {
        return Aggregate.valueOf(this.aggregate);
    }

    @JsonIgnore
    public void setAggregate(String aggregate) {
        this.aggregate = aggregate;
    }

    @JsonIgnore
    public void setAggregateFromEnum(Aggregate aggregate) {
        this.aggregate = aggregate.toString();
    }

    @JsonIgnore
    public List<String> getSpecials() {
        return this.specials;
    }

    @JsonIgnore
    public List<Specials> getSpecialsAsEnum() {
        ArrayList<Specials> en = new ArrayList<Specials>();
        for (String e : this.specials) {
            en.add(Specials.valueOf(e));
        }
        return en;
    }

    @JsonIgnore
    public void setSpecials(List<String> specials) {
        this.specials = specials;
    }

    @JsonIgnore
    public void setSpecialsFromEnum(List<Specials> specials) {
        ArrayList<String> en = new ArrayList<String>();
        for (Specials e : specials) {
            en.add(e.toString());
        }
        this.specials = en;
    }

    @JsonIgnore
    public PaymentProviderConfigInfo createFromJson(String json) throws JsonProcessingException {
        return (PaymentProviderConfigInfo)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<PaymentProviderConfigInfo> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<PaymentProviderConfigInfo>>(){});
    }

    public static PaymentProviderConfigInfoBuilder builder() {
        return new PaymentProviderConfigInfoBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPaymentMerchantConfigId() {
        return this.paymentMerchantConfigId;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSandboxTaxJarApiToken() {
        return this.sandboxTaxJarApiToken;
    }

    public String getTaxJarApiToken() {
        return this.taxJarApiToken;
    }

    public Boolean getTaxJarEnabled() {
        return this.taxJarEnabled;
    }

    public Boolean getUseGlobalTaxJarApiToken() {
        return this.useGlobalTaxJarApiToken;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty(value="paymentMerchantConfigId")
    public void setPaymentMerchantConfigId(String paymentMerchantConfigId) {
        this.paymentMerchantConfigId = paymentMerchantConfigId;
    }

    @JsonProperty(value="region")
    public void setRegion(String region) {
        this.region = region;
    }

    @JsonProperty(value="sandboxTaxJarApiToken")
    public void setSandboxTaxJarApiToken(String sandboxTaxJarApiToken) {
        this.sandboxTaxJarApiToken = sandboxTaxJarApiToken;
    }

    @JsonProperty(value="taxJarApiToken")
    public void setTaxJarApiToken(String taxJarApiToken) {
        this.taxJarApiToken = taxJarApiToken;
    }

    @JsonProperty(value="taxJarEnabled")
    public void setTaxJarEnabled(Boolean taxJarEnabled) {
        this.taxJarEnabled = taxJarEnabled;
    }

    @JsonProperty(value="useGlobalTaxJarApiToken")
    public void setUseGlobalTaxJarApiToken(Boolean useGlobalTaxJarApiToken) {
        this.useGlobalTaxJarApiToken = useGlobalTaxJarApiToken;
    }

    @Deprecated
    public PaymentProviderConfigInfo(String aggregate, String id, String namespace, String paymentMerchantConfigId, String region, String sandboxTaxJarApiToken, List<String> specials, String taxJarApiToken, Boolean taxJarEnabled, Boolean useGlobalTaxJarApiToken) {
        this.aggregate = aggregate;
        this.id = id;
        this.namespace = namespace;
        this.paymentMerchantConfigId = paymentMerchantConfigId;
        this.region = region;
        this.sandboxTaxJarApiToken = sandboxTaxJarApiToken;
        this.specials = specials;
        this.taxJarApiToken = taxJarApiToken;
        this.taxJarEnabled = taxJarEnabled;
        this.useGlobalTaxJarApiToken = useGlobalTaxJarApiToken;
    }

    public PaymentProviderConfigInfo() {
    }

    public static class PaymentProviderConfigInfoBuilder {
        private String id;
        private String namespace;
        private String paymentMerchantConfigId;
        private String region;
        private String sandboxTaxJarApiToken;
        private String taxJarApiToken;
        private Boolean taxJarEnabled;
        private Boolean useGlobalTaxJarApiToken;
        private String aggregate;
        private List<String> specials;

        public PaymentProviderConfigInfoBuilder aggregate(String aggregate) {
            this.aggregate = aggregate;
            return this;
        }

        public PaymentProviderConfigInfoBuilder aggregateFromEnum(Aggregate aggregate) {
            this.aggregate = aggregate.toString();
            return this;
        }

        public PaymentProviderConfigInfoBuilder specials(List<String> specials) {
            this.specials = specials;
            return this;
        }

        public PaymentProviderConfigInfoBuilder specialsFromEnum(List<Specials> specials) {
            ArrayList<String> en = new ArrayList<String>();
            for (Specials e : specials) {
                en.add(e.toString());
            }
            this.specials = en;
            return this;
        }

        PaymentProviderConfigInfoBuilder() {
        }

        @JsonProperty(value="id")
        public PaymentProviderConfigInfoBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="namespace")
        public PaymentProviderConfigInfoBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @JsonProperty(value="paymentMerchantConfigId")
        public PaymentProviderConfigInfoBuilder paymentMerchantConfigId(String paymentMerchantConfigId) {
            this.paymentMerchantConfigId = paymentMerchantConfigId;
            return this;
        }

        @JsonProperty(value="region")
        public PaymentProviderConfigInfoBuilder region(String region) {
            this.region = region;
            return this;
        }

        @JsonProperty(value="sandboxTaxJarApiToken")
        public PaymentProviderConfigInfoBuilder sandboxTaxJarApiToken(String sandboxTaxJarApiToken) {
            this.sandboxTaxJarApiToken = sandboxTaxJarApiToken;
            return this;
        }

        @JsonProperty(value="taxJarApiToken")
        public PaymentProviderConfigInfoBuilder taxJarApiToken(String taxJarApiToken) {
            this.taxJarApiToken = taxJarApiToken;
            return this;
        }

        @JsonProperty(value="taxJarEnabled")
        public PaymentProviderConfigInfoBuilder taxJarEnabled(Boolean taxJarEnabled) {
            this.taxJarEnabled = taxJarEnabled;
            return this;
        }

        @JsonProperty(value="useGlobalTaxJarApiToken")
        public PaymentProviderConfigInfoBuilder useGlobalTaxJarApiToken(Boolean useGlobalTaxJarApiToken) {
            this.useGlobalTaxJarApiToken = useGlobalTaxJarApiToken;
            return this;
        }

        public PaymentProviderConfigInfo build() {
            return new PaymentProviderConfigInfo(this.aggregate, this.id, this.namespace, this.paymentMerchantConfigId, this.region, this.sandboxTaxJarApiToken, this.specials, this.taxJarApiToken, this.taxJarEnabled, this.useGlobalTaxJarApiToken);
        }

        public String toString() {
            return "PaymentProviderConfigInfo.PaymentProviderConfigInfoBuilder(aggregate=" + this.aggregate + ", id=" + this.id + ", namespace=" + this.namespace + ", paymentMerchantConfigId=" + this.paymentMerchantConfigId + ", region=" + this.region + ", sandboxTaxJarApiToken=" + this.sandboxTaxJarApiToken + ", specials=" + this.specials + ", taxJarApiToken=" + this.taxJarApiToken + ", taxJarEnabled=" + this.taxJarEnabled + ", useGlobalTaxJarApiToken=" + this.useGlobalTaxJarApiToken + ")";
        }
    }

    public static enum Specials {
        ADYEN("ADYEN"),
        ALIPAY("ALIPAY"),
        CHECKOUT("CHECKOUT"),
        PAYPAL("PAYPAL"),
        STRIPE("STRIPE"),
        WALLET("WALLET"),
        WXPAY("WXPAY"),
        XSOLLA("XSOLLA");

        private String value;

        private Specials(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Aggregate {
        ADYEN("ADYEN"),
        CHECKOUT("CHECKOUT"),
        STRIPE("STRIPE"),
        XSOLLA("XSOLLA");

        private String value;

        private Aggregate(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

