/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PaymentOrderRefundResult
extends Model {
    @JsonProperty(value="createdTime")
    private String createdTime;
    @JsonProperty(value="namespace")
    private String namespace;
    @JsonProperty(value="paymentOrderNo")
    private String paymentOrderNo;
    @JsonProperty(value="refundedTime")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String refundedTime;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="targetNamespace")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String targetNamespace;
    @JsonProperty(value="targetUserId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String targetUserId;

    @JsonIgnore
    public String getStatus() {
        return this.status;
    }

    @JsonIgnore
    public Status getStatusAsEnum() {
        return Status.valueOf(this.status);
    }

    @JsonIgnore
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonIgnore
    public void setStatusFromEnum(Status status) {
        this.status = status.toString();
    }

    @JsonIgnore
    public PaymentOrderRefundResult createFromJson(String json) throws JsonProcessingException {
        return (PaymentOrderRefundResult)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<PaymentOrderRefundResult> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<PaymentOrderRefundResult>>(){});
    }

    public static PaymentOrderRefundResultBuilder builder() {
        return new PaymentOrderRefundResultBuilder();
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPaymentOrderNo() {
        return this.paymentOrderNo;
    }

    public String getRefundedTime() {
        return this.refundedTime;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getTargetUserId() {
        return this.targetUserId;
    }

    @JsonProperty(value="createdTime")
    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty(value="paymentOrderNo")
    public void setPaymentOrderNo(String paymentOrderNo) {
        this.paymentOrderNo = paymentOrderNo;
    }

    @JsonProperty(value="refundedTime")
    public void setRefundedTime(String refundedTime) {
        this.refundedTime = refundedTime;
    }

    @JsonProperty(value="targetNamespace")
    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    @JsonProperty(value="targetUserId")
    public void setTargetUserId(String targetUserId) {
        this.targetUserId = targetUserId;
    }

    @Deprecated
    public PaymentOrderRefundResult(String createdTime, String namespace, String paymentOrderNo, String refundedTime, String status, String targetNamespace, String targetUserId) {
        this.createdTime = createdTime;
        this.namespace = namespace;
        this.paymentOrderNo = paymentOrderNo;
        this.refundedTime = refundedTime;
        this.status = status;
        this.targetNamespace = targetNamespace;
        this.targetUserId = targetUserId;
    }

    public PaymentOrderRefundResult() {
    }

    public static class PaymentOrderRefundResultBuilder {
        private String createdTime;
        private String namespace;
        private String paymentOrderNo;
        private String refundedTime;
        private String targetNamespace;
        private String targetUserId;
        private String status;

        public PaymentOrderRefundResultBuilder status(String status) {
            this.status = status;
            return this;
        }

        public PaymentOrderRefundResultBuilder statusFromEnum(Status status) {
            this.status = status.toString();
            return this;
        }

        PaymentOrderRefundResultBuilder() {
        }

        @JsonProperty(value="createdTime")
        public PaymentOrderRefundResultBuilder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @JsonProperty(value="namespace")
        public PaymentOrderRefundResultBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @JsonProperty(value="paymentOrderNo")
        public PaymentOrderRefundResultBuilder paymentOrderNo(String paymentOrderNo) {
            this.paymentOrderNo = paymentOrderNo;
            return this;
        }

        @JsonProperty(value="refundedTime")
        public PaymentOrderRefundResultBuilder refundedTime(String refundedTime) {
            this.refundedTime = refundedTime;
            return this;
        }

        @JsonProperty(value="targetNamespace")
        public PaymentOrderRefundResultBuilder targetNamespace(String targetNamespace) {
            this.targetNamespace = targetNamespace;
            return this;
        }

        @JsonProperty(value="targetUserId")
        public PaymentOrderRefundResultBuilder targetUserId(String targetUserId) {
            this.targetUserId = targetUserId;
            return this;
        }

        public PaymentOrderRefundResult build() {
            return new PaymentOrderRefundResult(this.createdTime, this.namespace, this.paymentOrderNo, this.refundedTime, this.status, this.targetNamespace, this.targetUserId);
        }

        public String toString() {
            return "PaymentOrderRefundResult.PaymentOrderRefundResultBuilder(createdTime=" + this.createdTime + ", namespace=" + this.namespace + ", paymentOrderNo=" + this.paymentOrderNo + ", refundedTime=" + this.refundedTime + ", status=" + this.status + ", targetNamespace=" + this.targetNamespace + ", targetUserId=" + this.targetUserId + ")";
        }
    }

    public static enum Status {
        AUTHORISED("AUTHORISED"),
        AUTHORISEFAILED("AUTHORISE_FAILED"),
        CHARGEBACK("CHARGEBACK"),
        CHARGEBACKREVERSED("CHARGEBACK_REVERSED"),
        CHARGED("CHARGED"),
        CHARGEFAILED("CHARGE_FAILED"),
        DELETED("DELETED"),
        INIT("INIT"),
        NOTIFICATIONOFCHARGEBACK("NOTIFICATION_OF_CHARGEBACK"),
        REFUNDED("REFUNDED"),
        REFUNDING("REFUNDING"),
        REFUNDFAILED("REFUND_FAILED"),
        REQUESTFORINFORMATION("REQUEST_FOR_INFORMATION");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

