/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PaymentOrderChargeStatus
extends Model {
    @JsonProperty(value="charging")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean charging;
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String status;

    @JsonIgnore
    public String getStatus() {
        return this.status;
    }

    @JsonIgnore
    public Status getStatusAsEnum() {
        return Status.valueOf(this.status);
    }

    @JsonIgnore
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonIgnore
    public void setStatusFromEnum(Status status) {
        this.status = status.toString();
    }

    @JsonIgnore
    public PaymentOrderChargeStatus createFromJson(String json) throws JsonProcessingException {
        return (PaymentOrderChargeStatus)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<PaymentOrderChargeStatus> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<PaymentOrderChargeStatus>>(){});
    }

    public static PaymentOrderChargeStatusBuilder builder() {
        return new PaymentOrderChargeStatusBuilder();
    }

    public Boolean getCharging() {
        return this.charging;
    }

    @JsonProperty(value="charging")
    public void setCharging(Boolean charging) {
        this.charging = charging;
    }

    @Deprecated
    public PaymentOrderChargeStatus(Boolean charging, String status) {
        this.charging = charging;
        this.status = status;
    }

    public PaymentOrderChargeStatus() {
    }

    public static class PaymentOrderChargeStatusBuilder {
        private Boolean charging;
        private String status;

        public PaymentOrderChargeStatusBuilder status(String status) {
            this.status = status;
            return this;
        }

        public PaymentOrderChargeStatusBuilder statusFromEnum(Status status) {
            this.status = status.toString();
            return this;
        }

        PaymentOrderChargeStatusBuilder() {
        }

        @JsonProperty(value="charging")
        public PaymentOrderChargeStatusBuilder charging(Boolean charging) {
            this.charging = charging;
            return this;
        }

        public PaymentOrderChargeStatus build() {
            return new PaymentOrderChargeStatus(this.charging, this.status);
        }

        public String toString() {
            return "PaymentOrderChargeStatus.PaymentOrderChargeStatusBuilder(charging=" + this.charging + ", status=" + this.status + ")";
        }
    }

    public static enum Status {
        AUTHORISED("AUTHORISED"),
        AUTHORISEFAILED("AUTHORISE_FAILED"),
        CHARGEBACK("CHARGEBACK"),
        CHARGEBACKREVERSED("CHARGEBACK_REVERSED"),
        CHARGED("CHARGED"),
        CHARGEFAILED("CHARGE_FAILED"),
        DELETED("DELETED"),
        INIT("INIT"),
        NOTIFICATIONOFCHARGEBACK("NOTIFICATION_OF_CHARGEBACK"),
        REFUNDED("REFUNDED"),
        REFUNDING("REFUNDING"),
        REFUNDFAILED("REFUND_FAILED"),
        REQUESTFORINFORMATION("REQUEST_FOR_INFORMATION");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

