/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PaymentOrderChargeRequest
extends Model {
    @JsonProperty(value="extTxId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String extTxId;
    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String paymentMethod;
    @JsonProperty(value="paymentProvider")
    private String paymentProvider;

    @JsonIgnore
    public String getPaymentProvider() {
        return this.paymentProvider;
    }

    @JsonIgnore
    public PaymentProvider getPaymentProviderAsEnum() {
        return PaymentProvider.valueOf(this.paymentProvider);
    }

    @JsonIgnore
    public void setPaymentProvider(String paymentProvider) {
        this.paymentProvider = paymentProvider;
    }

    @JsonIgnore
    public void setPaymentProviderFromEnum(PaymentProvider paymentProvider) {
        this.paymentProvider = paymentProvider.toString();
    }

    @JsonIgnore
    public PaymentOrderChargeRequest createFromJson(String json) throws JsonProcessingException {
        return (PaymentOrderChargeRequest)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<PaymentOrderChargeRequest> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<PaymentOrderChargeRequest>>(){});
    }

    public static PaymentOrderChargeRequestBuilder builder() {
        return new PaymentOrderChargeRequestBuilder();
    }

    public String getExtTxId() {
        return this.extTxId;
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="extTxId")
    public void setExtTxId(String extTxId) {
        this.extTxId = extTxId;
    }

    @JsonProperty(value="paymentMethod")
    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    @Deprecated
    public PaymentOrderChargeRequest(String extTxId, String paymentMethod, String paymentProvider) {
        this.extTxId = extTxId;
        this.paymentMethod = paymentMethod;
        this.paymentProvider = paymentProvider;
    }

    public PaymentOrderChargeRequest() {
    }

    public static class PaymentOrderChargeRequestBuilder {
        private String extTxId;
        private String paymentMethod;
        private String paymentProvider;

        public PaymentOrderChargeRequestBuilder paymentProvider(String paymentProvider) {
            this.paymentProvider = paymentProvider;
            return this;
        }

        public PaymentOrderChargeRequestBuilder paymentProviderFromEnum(PaymentProvider paymentProvider) {
            this.paymentProvider = paymentProvider.toString();
            return this;
        }

        PaymentOrderChargeRequestBuilder() {
        }

        @JsonProperty(value="extTxId")
        public PaymentOrderChargeRequestBuilder extTxId(String extTxId) {
            this.extTxId = extTxId;
            return this;
        }

        @JsonProperty(value="paymentMethod")
        public PaymentOrderChargeRequestBuilder paymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public PaymentOrderChargeRequest build() {
            return new PaymentOrderChargeRequest(this.extTxId, this.paymentMethod, this.paymentProvider);
        }

        public String toString() {
            return "PaymentOrderChargeRequest.PaymentOrderChargeRequestBuilder(extTxId=" + this.extTxId + ", paymentMethod=" + this.paymentMethod + ", paymentProvider=" + this.paymentProvider + ")";
        }
    }

    public static enum PaymentProvider {
        ADYEN("ADYEN"),
        ALIPAY("ALIPAY"),
        CHECKOUT("CHECKOUT"),
        PAYPAL("PAYPAL"),
        STRIPE("STRIPE"),
        WALLET("WALLET"),
        WXPAY("WXPAY"),
        XSOLLA("XSOLLA");

        private String value;

        private PaymentProvider(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

