/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PaymentMethod
extends Model {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="paymentProvider")
    private String paymentProvider;

    @JsonIgnore
    public String getPaymentProvider() {
        return this.paymentProvider;
    }

    @JsonIgnore
    public PaymentProvider getPaymentProviderAsEnum() {
        return PaymentProvider.valueOf(this.paymentProvider);
    }

    @JsonIgnore
    public void setPaymentProvider(String paymentProvider) {
        this.paymentProvider = paymentProvider;
    }

    @JsonIgnore
    public void setPaymentProviderFromEnum(PaymentProvider paymentProvider) {
        this.paymentProvider = paymentProvider.toString();
    }

    @JsonIgnore
    public PaymentMethod createFromJson(String json) throws JsonProcessingException {
        return (PaymentMethod)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<PaymentMethod> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<PaymentMethod>>(){});
    }

    public static PaymentMethodBuilder builder() {
        return new PaymentMethodBuilder();
    }

    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @Deprecated
    public PaymentMethod(String name, String paymentProvider) {
        this.name = name;
        this.paymentProvider = paymentProvider;
    }

    public PaymentMethod() {
    }

    public static class PaymentMethodBuilder {
        private String name;
        private String paymentProvider;

        public PaymentMethodBuilder paymentProvider(String paymentProvider) {
            this.paymentProvider = paymentProvider;
            return this;
        }

        public PaymentMethodBuilder paymentProviderFromEnum(PaymentProvider paymentProvider) {
            this.paymentProvider = paymentProvider.toString();
            return this;
        }

        PaymentMethodBuilder() {
        }

        @JsonProperty(value="name")
        public PaymentMethodBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PaymentMethod build() {
            return new PaymentMethod(this.name, this.paymentProvider);
        }

        public String toString() {
            return "PaymentMethod.PaymentMethodBuilder(name=" + this.name + ", paymentProvider=" + this.paymentProvider + ")";
        }
    }

    public static enum PaymentProvider {
        ADYEN("ADYEN"),
        ALIPAY("ALIPAY"),
        CHECKOUT("CHECKOUT"),
        PAYPAL("PAYPAL"),
        STRIPE("STRIPE"),
        WALLET("WALLET"),
        WXPAY("WXPAY"),
        XSOLLA("XSOLLA");

        private String value;

        private PaymentProvider(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

