/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.api.platform.models.LootBoxReward;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LootBoxConfig
extends Model {
    @JsonProperty(value="rewardCount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer rewardCount;
    @JsonProperty(value="rewards")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<LootBoxReward> rewards;
    @JsonProperty(value="rollFunction")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String rollFunction;

    @JsonIgnore
    public String getRollFunction() {
        return this.rollFunction;
    }

    @JsonIgnore
    public RollFunction getRollFunctionAsEnum() {
        return RollFunction.valueOf(this.rollFunction);
    }

    @JsonIgnore
    public void setRollFunction(String rollFunction) {
        this.rollFunction = rollFunction;
    }

    @JsonIgnore
    public void setRollFunctionFromEnum(RollFunction rollFunction) {
        this.rollFunction = rollFunction.toString();
    }

    @JsonIgnore
    public LootBoxConfig createFromJson(String json) throws JsonProcessingException {
        return (LootBoxConfig)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<LootBoxConfig> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<LootBoxConfig>>(){});
    }

    public static LootBoxConfigBuilder builder() {
        return new LootBoxConfigBuilder();
    }

    public Integer getRewardCount() {
        return this.rewardCount;
    }

    public List<LootBoxReward> getRewards() {
        return this.rewards;
    }

    @JsonProperty(value="rewardCount")
    public void setRewardCount(Integer rewardCount) {
        this.rewardCount = rewardCount;
    }

    @JsonProperty(value="rewards")
    public void setRewards(List<LootBoxReward> rewards) {
        this.rewards = rewards;
    }

    @Deprecated
    public LootBoxConfig(Integer rewardCount, List<LootBoxReward> rewards, String rollFunction) {
        this.rewardCount = rewardCount;
        this.rewards = rewards;
        this.rollFunction = rollFunction;
    }

    public LootBoxConfig() {
    }

    public static class LootBoxConfigBuilder {
        private Integer rewardCount;
        private List<LootBoxReward> rewards;
        private String rollFunction;

        public LootBoxConfigBuilder rollFunction(String rollFunction) {
            this.rollFunction = rollFunction;
            return this;
        }

        public LootBoxConfigBuilder rollFunctionFromEnum(RollFunction rollFunction) {
            this.rollFunction = rollFunction.toString();
            return this;
        }

        LootBoxConfigBuilder() {
        }

        @JsonProperty(value="rewardCount")
        public LootBoxConfigBuilder rewardCount(Integer rewardCount) {
            this.rewardCount = rewardCount;
            return this;
        }

        @JsonProperty(value="rewards")
        public LootBoxConfigBuilder rewards(List<LootBoxReward> rewards) {
            this.rewards = rewards;
            return this;
        }

        public LootBoxConfig build() {
            return new LootBoxConfig(this.rewardCount, this.rewards, this.rollFunction);
        }

        public String toString() {
            return "LootBoxConfig.LootBoxConfigBuilder(rewardCount=" + this.rewardCount + ", rewards=" + this.rewards + ", rollFunction=" + this.rollFunction + ")";
        }
    }

    public static enum RollFunction {
        CUSTOM("CUSTOM"),
        DEFAULT("DEFAULT");

        private String value;

        private RollFunction(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

