/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.api.platform.models.Predicate;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConditionGroup
extends Model {
    @JsonProperty(value="operator")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String operator;
    @JsonProperty(value="predicates")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<Predicate> predicates;

    @JsonIgnore
    public String getOperator() {
        return this.operator;
    }

    @JsonIgnore
    public Operator getOperatorAsEnum() {
        return Operator.valueOf(this.operator);
    }

    @JsonIgnore
    public void setOperator(String operator) {
        this.operator = operator;
    }

    @JsonIgnore
    public void setOperatorFromEnum(Operator operator) {
        this.operator = operator.toString();
    }

    @JsonIgnore
    public ConditionGroup createFromJson(String json) throws JsonProcessingException {
        return (ConditionGroup)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<ConditionGroup> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<ConditionGroup>>(){});
    }

    public static ConditionGroupBuilder builder() {
        return new ConditionGroupBuilder();
    }

    public List<Predicate> getPredicates() {
        return this.predicates;
    }

    @JsonProperty(value="predicates")
    public void setPredicates(List<Predicate> predicates) {
        this.predicates = predicates;
    }

    @Deprecated
    public ConditionGroup(String operator, List<Predicate> predicates) {
        this.operator = operator;
        this.predicates = predicates;
    }

    public ConditionGroup() {
    }

    public static class ConditionGroupBuilder {
        private List<Predicate> predicates;
        private String operator;

        public ConditionGroupBuilder operator(String operator) {
            this.operator = operator;
            return this;
        }

        public ConditionGroupBuilder operatorFromEnum(Operator operator) {
            this.operator = operator.toString();
            return this;
        }

        ConditionGroupBuilder() {
        }

        @JsonProperty(value="predicates")
        public ConditionGroupBuilder predicates(List<Predicate> predicates) {
            this.predicates = predicates;
            return this;
        }

        public ConditionGroup build() {
            return new ConditionGroup(this.operator, this.predicates);
        }

        public String toString() {
            return "ConditionGroup.ConditionGroupBuilder(operator=" + this.operator + ", predicates=" + this.predicates + ")";
        }
    }

    public static enum Operator {
        And("and"),
        Or("or");

        private String value;

        private Operator(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

