/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.api.platform.models.AdditionalData;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BillingAccount
extends Model {
    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private AdditionalData additionalData;
    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String paymentMethod;
    @JsonProperty(value="paymentProvider")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String paymentProvider;

    @JsonIgnore
    public String getPaymentProvider() {
        return this.paymentProvider;
    }

    @JsonIgnore
    public PaymentProvider getPaymentProviderAsEnum() {
        return PaymentProvider.valueOf(this.paymentProvider);
    }

    @JsonIgnore
    public void setPaymentProvider(String paymentProvider) {
        this.paymentProvider = paymentProvider;
    }

    @JsonIgnore
    public void setPaymentProviderFromEnum(PaymentProvider paymentProvider) {
        this.paymentProvider = paymentProvider.toString();
    }

    @JsonIgnore
    public BillingAccount createFromJson(String json) throws JsonProcessingException {
        return (BillingAccount)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<BillingAccount> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<BillingAccount>>(){});
    }

    public static BillingAccountBuilder builder() {
        return new BillingAccountBuilder();
    }

    public AdditionalData getAdditionalData() {
        return this.additionalData;
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="additionalData")
    public void setAdditionalData(AdditionalData additionalData) {
        this.additionalData = additionalData;
    }

    @JsonProperty(value="paymentMethod")
    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    @Deprecated
    public BillingAccount(AdditionalData additionalData, String paymentMethod, String paymentProvider) {
        this.additionalData = additionalData;
        this.paymentMethod = paymentMethod;
        this.paymentProvider = paymentProvider;
    }

    public BillingAccount() {
    }

    public static class BillingAccountBuilder {
        private AdditionalData additionalData;
        private String paymentMethod;
        private String paymentProvider;

        public BillingAccountBuilder paymentProvider(String paymentProvider) {
            this.paymentProvider = paymentProvider;
            return this;
        }

        public BillingAccountBuilder paymentProviderFromEnum(PaymentProvider paymentProvider) {
            this.paymentProvider = paymentProvider.toString();
            return this;
        }

        BillingAccountBuilder() {
        }

        @JsonProperty(value="additionalData")
        public BillingAccountBuilder additionalData(AdditionalData additionalData) {
            this.additionalData = additionalData;
            return this;
        }

        @JsonProperty(value="paymentMethod")
        public BillingAccountBuilder paymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public BillingAccount build() {
            return new BillingAccount(this.additionalData, this.paymentMethod, this.paymentProvider);
        }

        public String toString() {
            return "BillingAccount.BillingAccountBuilder(additionalData=" + (Object)((Object)this.additionalData) + ", paymentMethod=" + this.paymentMethod + ", paymentProvider=" + this.paymentProvider + ")";
        }
    }

    public static enum PaymentProvider {
        ADYEN("ADYEN"),
        ALIPAY("ALIPAY"),
        CHECKOUT("CHECKOUT"),
        PAYPAL("PAYPAL"),
        STRIPE("STRIPE"),
        WALLET("WALLET"),
        WXPAY("WXPAY"),
        XSOLLA("XSOLLA");

        private String value;

        private PaymentProvider(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

