/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.Requirement;
import net.accelbyte.sdk.api.platform.models.Slide;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AppInfo
extends Model {
    @JsonProperty(value="announcement")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String announcement;
    @JsonProperty(value="carousel")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<Slide> carousel;
    @JsonProperty(value="developer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String developer;
    @JsonProperty(value="forumUrl")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String forumUrl;
    @JsonProperty(value="genres")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> genres;
    @JsonProperty(value="itemId")
    private String itemId;
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String language;
    @JsonProperty(value="namespace")
    private String namespace;
    @JsonProperty(value="platformRequirements")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, List<Requirement>> platformRequirements;
    @JsonProperty(value="platforms")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> platforms;
    @JsonProperty(value="players")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> players;
    @JsonProperty(value="primaryGenre")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String primaryGenre;
    @JsonProperty(value="publisher")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String publisher;
    @JsonProperty(value="region")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String region;
    @JsonProperty(value="releaseDate")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String releaseDate;
    @JsonProperty(value="slogan")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String slogan;
    @JsonProperty(value="websiteUrl")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String websiteUrl;

    @JsonIgnore
    public List<String> getGenres() {
        return this.genres;
    }

    @JsonIgnore
    public List<Genres> getGenresAsEnum() {
        ArrayList<Genres> en = new ArrayList<Genres>();
        for (String e : this.genres) {
            en.add(Genres.valueOf(e));
        }
        return en;
    }

    @JsonIgnore
    public void setGenres(List<String> genres) {
        this.genres = genres;
    }

    @JsonIgnore
    public void setGenresFromEnum(List<Genres> genres) {
        ArrayList<String> en = new ArrayList<String>();
        for (Genres e : genres) {
            en.add(e.toString());
        }
        this.genres = en;
    }

    @JsonIgnore
    public List<String> getPlatforms() {
        return this.platforms;
    }

    @JsonIgnore
    public List<Platforms> getPlatformsAsEnum() {
        ArrayList<Platforms> en = new ArrayList<Platforms>();
        for (String e : this.platforms) {
            en.add(Platforms.valueOf(e));
        }
        return en;
    }

    @JsonIgnore
    public void setPlatforms(List<String> platforms) {
        this.platforms = platforms;
    }

    @JsonIgnore
    public void setPlatformsFromEnum(List<Platforms> platforms) {
        ArrayList<String> en = new ArrayList<String>();
        for (Platforms e : platforms) {
            en.add(e.toString());
        }
        this.platforms = en;
    }

    @JsonIgnore
    public List<String> getPlayers() {
        return this.players;
    }

    @JsonIgnore
    public List<Players> getPlayersAsEnum() {
        ArrayList<Players> en = new ArrayList<Players>();
        for (String e : this.players) {
            en.add(Players.valueOf(e));
        }
        return en;
    }

    @JsonIgnore
    public void setPlayers(List<String> players) {
        this.players = players;
    }

    @JsonIgnore
    public void setPlayersFromEnum(List<Players> players) {
        ArrayList<String> en = new ArrayList<String>();
        for (Players e : players) {
            en.add(e.toString());
        }
        this.players = en;
    }

    @JsonIgnore
    public String getPrimaryGenre() {
        return this.primaryGenre;
    }

    @JsonIgnore
    public PrimaryGenre getPrimaryGenreAsEnum() {
        return PrimaryGenre.valueOf(this.primaryGenre);
    }

    @JsonIgnore
    public void setPrimaryGenre(String primaryGenre) {
        this.primaryGenre = primaryGenre;
    }

    @JsonIgnore
    public void setPrimaryGenreFromEnum(PrimaryGenre primaryGenre) {
        this.primaryGenre = primaryGenre.toString();
    }

    @JsonIgnore
    public AppInfo createFromJson(String json) throws JsonProcessingException {
        return (AppInfo)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<AppInfo> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<AppInfo>>(){});
    }

    public static AppInfoBuilder builder() {
        return new AppInfoBuilder();
    }

    public String getAnnouncement() {
        return this.announcement;
    }

    public List<Slide> getCarousel() {
        return this.carousel;
    }

    public String getDeveloper() {
        return this.developer;
    }

    public String getForumUrl() {
        return this.forumUrl;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, List<Requirement>> getPlatformRequirements() {
        return this.platformRequirements;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public String getRegion() {
        return this.region;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public String getSlogan() {
        return this.slogan;
    }

    public String getWebsiteUrl() {
        return this.websiteUrl;
    }

    @JsonProperty(value="announcement")
    public void setAnnouncement(String announcement) {
        this.announcement = announcement;
    }

    @JsonProperty(value="carousel")
    public void setCarousel(List<Slide> carousel) {
        this.carousel = carousel;
    }

    @JsonProperty(value="developer")
    public void setDeveloper(String developer) {
        this.developer = developer;
    }

    @JsonProperty(value="forumUrl")
    public void setForumUrl(String forumUrl) {
        this.forumUrl = forumUrl;
    }

    @JsonProperty(value="itemId")
    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    @JsonProperty(value="language")
    public void setLanguage(String language) {
        this.language = language;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty(value="platformRequirements")
    public void setPlatformRequirements(Map<String, List<Requirement>> platformRequirements) {
        this.platformRequirements = platformRequirements;
    }

    @JsonProperty(value="publisher")
    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    @JsonProperty(value="region")
    public void setRegion(String region) {
        this.region = region;
    }

    @JsonProperty(value="releaseDate")
    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    @JsonProperty(value="slogan")
    public void setSlogan(String slogan) {
        this.slogan = slogan;
    }

    @JsonProperty(value="websiteUrl")
    public void setWebsiteUrl(String websiteUrl) {
        this.websiteUrl = websiteUrl;
    }

    @Deprecated
    public AppInfo(String announcement, List<Slide> carousel, String developer, String forumUrl, List<String> genres, String itemId, String language, String namespace, Map<String, List<Requirement>> platformRequirements, List<String> platforms, List<String> players, String primaryGenre, String publisher, String region, String releaseDate, String slogan, String websiteUrl) {
        this.announcement = announcement;
        this.carousel = carousel;
        this.developer = developer;
        this.forumUrl = forumUrl;
        this.genres = genres;
        this.itemId = itemId;
        this.language = language;
        this.namespace = namespace;
        this.platformRequirements = platformRequirements;
        this.platforms = platforms;
        this.players = players;
        this.primaryGenre = primaryGenre;
        this.publisher = publisher;
        this.region = region;
        this.releaseDate = releaseDate;
        this.slogan = slogan;
        this.websiteUrl = websiteUrl;
    }

    public AppInfo() {
    }

    public static class AppInfoBuilder {
        private String announcement;
        private List<Slide> carousel;
        private String developer;
        private String forumUrl;
        private String itemId;
        private String language;
        private String namespace;
        private Map<String, List<Requirement>> platformRequirements;
        private String publisher;
        private String region;
        private String releaseDate;
        private String slogan;
        private String websiteUrl;
        private List<String> genres;
        private List<String> platforms;
        private List<String> players;
        private String primaryGenre;

        public AppInfoBuilder genres(List<String> genres) {
            this.genres = genres;
            return this;
        }

        public AppInfoBuilder genresFromEnum(List<Genres> genres) {
            ArrayList<String> en = new ArrayList<String>();
            for (Genres e : genres) {
                en.add(e.toString());
            }
            this.genres = en;
            return this;
        }

        public AppInfoBuilder platforms(List<String> platforms) {
            this.platforms = platforms;
            return this;
        }

        public AppInfoBuilder platformsFromEnum(List<Platforms> platforms) {
            ArrayList<String> en = new ArrayList<String>();
            for (Platforms e : platforms) {
                en.add(e.toString());
            }
            this.platforms = en;
            return this;
        }

        public AppInfoBuilder players(List<String> players) {
            this.players = players;
            return this;
        }

        public AppInfoBuilder playersFromEnum(List<Players> players) {
            ArrayList<String> en = new ArrayList<String>();
            for (Players e : players) {
                en.add(e.toString());
            }
            this.players = en;
            return this;
        }

        public AppInfoBuilder primaryGenre(String primaryGenre) {
            this.primaryGenre = primaryGenre;
            return this;
        }

        public AppInfoBuilder primaryGenreFromEnum(PrimaryGenre primaryGenre) {
            this.primaryGenre = primaryGenre.toString();
            return this;
        }

        AppInfoBuilder() {
        }

        @JsonProperty(value="announcement")
        public AppInfoBuilder announcement(String announcement) {
            this.announcement = announcement;
            return this;
        }

        @JsonProperty(value="carousel")
        public AppInfoBuilder carousel(List<Slide> carousel) {
            this.carousel = carousel;
            return this;
        }

        @JsonProperty(value="developer")
        public AppInfoBuilder developer(String developer) {
            this.developer = developer;
            return this;
        }

        @JsonProperty(value="forumUrl")
        public AppInfoBuilder forumUrl(String forumUrl) {
            this.forumUrl = forumUrl;
            return this;
        }

        @JsonProperty(value="itemId")
        public AppInfoBuilder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        @JsonProperty(value="language")
        public AppInfoBuilder language(String language) {
            this.language = language;
            return this;
        }

        @JsonProperty(value="namespace")
        public AppInfoBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @JsonProperty(value="platformRequirements")
        public AppInfoBuilder platformRequirements(Map<String, List<Requirement>> platformRequirements) {
            this.platformRequirements = platformRequirements;
            return this;
        }

        @JsonProperty(value="publisher")
        public AppInfoBuilder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        @JsonProperty(value="region")
        public AppInfoBuilder region(String region) {
            this.region = region;
            return this;
        }

        @JsonProperty(value="releaseDate")
        public AppInfoBuilder releaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        @JsonProperty(value="slogan")
        public AppInfoBuilder slogan(String slogan) {
            this.slogan = slogan;
            return this;
        }

        @JsonProperty(value="websiteUrl")
        public AppInfoBuilder websiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
            return this;
        }

        public AppInfo build() {
            return new AppInfo(this.announcement, this.carousel, this.developer, this.forumUrl, this.genres, this.itemId, this.language, this.namespace, this.platformRequirements, this.platforms, this.players, this.primaryGenre, this.publisher, this.region, this.releaseDate, this.slogan, this.websiteUrl);
        }

        public String toString() {
            return "AppInfo.AppInfoBuilder(announcement=" + this.announcement + ", carousel=" + this.carousel + ", developer=" + this.developer + ", forumUrl=" + this.forumUrl + ", genres=" + this.genres + ", itemId=" + this.itemId + ", language=" + this.language + ", namespace=" + this.namespace + ", platformRequirements=" + this.platformRequirements + ", platforms=" + this.platforms + ", players=" + this.players + ", primaryGenre=" + this.primaryGenre + ", publisher=" + this.publisher + ", region=" + this.region + ", releaseDate=" + this.releaseDate + ", slogan=" + this.slogan + ", websiteUrl=" + this.websiteUrl + ")";
        }
    }

    public static enum PrimaryGenre {
        Action("Action"),
        Adventure("Adventure"),
        Casual("Casual"),
        FreeToPlay("FreeToPlay"),
        Indie("Indie"),
        MassivelyMultiplayer("MassivelyMultiplayer"),
        RPG("RPG"),
        Racing("Racing"),
        Simulation("Simulation"),
        Sports("Sports"),
        Strategy("Strategy");

        private String value;

        private PrimaryGenre(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Players {
        Coop("Coop"),
        CrossPlatformMulti("CrossPlatformMulti"),
        LocalCoop("LocalCoop"),
        MMO("MMO"),
        Multi("Multi"),
        Single("Single");

        private String value;

        private Players(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Platforms {
        Android("Android"),
        IOS("IOS"),
        Linux("Linux"),
        MacOS("MacOS"),
        Windows("Windows");

        private String value;

        private Platforms(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Genres {
        Action("Action"),
        Adventure("Adventure"),
        Casual("Casual"),
        FreeToPlay("FreeToPlay"),
        Indie("Indie"),
        MassivelyMultiplayer("MassivelyMultiplayer"),
        RPG("RPG"),
        Racing("Racing"),
        Simulation("Simulation"),
        Sports("Sports"),
        Strategy("Strategy");

        private String value;

        private Genres(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

