/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.lobby.ws_models;

import java.util.HashMap;
import java.util.Map;
import net.accelbyte.sdk.core.util.Helper;

public class MessageSessionNotif {
    private String from;
    private String id;
    private String payload;
    private String sentAt;
    private String to;
    private String topic;

    private MessageSessionNotif() {
    }

    @Deprecated
    public MessageSessionNotif(String from, String id, String payload, String sentAt, String to, String topic) {
        this.from = from;
        this.id = id;
        this.payload = payload;
        this.sentAt = sentAt;
        this.to = to;
        this.topic = topic;
    }

    public static String getType() {
        return "messageSessionNotif";
    }

    public static MessageSessionNotif createFromWSM(String message) {
        MessageSessionNotif result = new MessageSessionNotif();
        Map response = Helper.parseWSM((String)message);
        result.from = response.get("from") != null ? (String)response.get("from") : null;
        result.id = response.get("id") != null ? (String)response.get("id") : null;
        result.payload = response.get("payload") != null ? (String)response.get("payload") : null;
        result.sentAt = response.get("sentAt") != null ? (String)response.get("sentAt") : null;
        result.to = response.get("to") != null ? (String)response.get("to") : null;
        result.topic = response.get("topic") != null ? (String)response.get("topic") : null;
        return result;
    }

    public String toWSM() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("type: ").append(MessageSessionNotif.getType());
        if (this.from != null) {
            stringBuilder.append("\n").append("from: ").append(this.from);
        }
        if (this.id != null) {
            stringBuilder.append("\n").append("id: ").append(this.id);
        } else {
            stringBuilder.append("\n").append("id: ").append(Helper.generateUUID());
        }
        if (this.payload != null) {
            stringBuilder.append("\n").append("payload: ").append(this.payload);
        }
        if (this.sentAt != null) {
            stringBuilder.append("\n").append("sentAt: ").append(this.sentAt);
        }
        if (this.to != null) {
            stringBuilder.append("\n").append("to: ").append(this.to);
        }
        if (this.topic != null) {
            stringBuilder.append("\n").append("topic: ").append(this.topic);
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> getFieldInfo() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("from", "from");
        result.put("id", "id");
        result.put("payload", "payload");
        result.put("sentAt", "sentAt");
        result.put("to", "to");
        result.put("topic", "topic");
        return result;
    }

    public static MessageSessionNotifBuilder builder() {
        return new MessageSessionNotifBuilder();
    }

    public String getFrom() {
        return this.from;
    }

    public String getId() {
        return this.id;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getSentAt() {
        return this.sentAt;
    }

    public String getTo() {
        return this.to;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setSentAt(String sentAt) {
        this.sentAt = sentAt;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public static class MessageSessionNotifBuilder {
        private String from;
        private String id;
        private String payload;
        private String sentAt;
        private String to;
        private String topic;

        MessageSessionNotifBuilder() {
        }

        public MessageSessionNotifBuilder from(String from) {
            this.from = from;
            return this;
        }

        public MessageSessionNotifBuilder id(String id) {
            this.id = id;
            return this;
        }

        public MessageSessionNotifBuilder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public MessageSessionNotifBuilder sentAt(String sentAt) {
            this.sentAt = sentAt;
            return this;
        }

        public MessageSessionNotifBuilder to(String to) {
            this.to = to;
            return this;
        }

        public MessageSessionNotifBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public MessageSessionNotif build() {
            return new MessageSessionNotif(this.from, this.id, this.payload, this.sentAt, this.to, this.topic);
        }

        public String toString() {
            return "MessageSessionNotif.MessageSessionNotifBuilder(from=" + this.from + ", id=" + this.id + ", payload=" + this.payload + ", sentAt=" + this.sentAt + ", to=" + this.to + ", topic=" + this.topic + ")";
        }
    }
}

