/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.lobby.operations.presence;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.lobby.models.HandlersGetUsersPresenceResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UsersPresenceHandlerV1
extends Operation {
    private String path = "/lobby/v1/public/presence/namespaces/{namespace}/users/presence";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private Boolean countOnly;
    private String userIds;

    @Deprecated
    public UsersPresenceHandlerV1(String namespace, Boolean countOnly, String userIds) {
        this.namespace = namespace;
        this.countOnly = countOnly;
        this.userIds = userIds;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("countOnly", this.countOnly == null ? null : Arrays.asList(String.valueOf(this.countOnly)));
        queryParams.put("userIds", this.userIds == null ? null : Arrays.asList(this.userIds));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userIds != null;
    }

    public HandlersGetUsersPresenceResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new HandlersGetUsersPresenceResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("countOnly", "None");
        result.put("userIds", "None");
        return result;
    }

    public static UsersPresenceHandlerV1Builder builder() {
        return new UsersPresenceHandlerV1Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Boolean getCountOnly() {
        return this.countOnly;
    }

    public String getUserIds() {
        return this.userIds;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setCountOnly(Boolean countOnly) {
        this.countOnly = countOnly;
    }

    public void setUserIds(String userIds) {
        this.userIds = userIds;
    }

    public static class UsersPresenceHandlerV1Builder {
        private String namespace;
        private Boolean countOnly;
        private String userIds;

        UsersPresenceHandlerV1Builder() {
        }

        public UsersPresenceHandlerV1Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UsersPresenceHandlerV1Builder countOnly(Boolean countOnly) {
            this.countOnly = countOnly;
            return this;
        }

        public UsersPresenceHandlerV1Builder userIds(String userIds) {
            this.userIds = userIds;
            return this;
        }

        public UsersPresenceHandlerV1 build() {
            return new UsersPresenceHandlerV1(this.namespace, this.countOnly, this.userIds);
        }

        public String toString() {
            return "UsersPresenceHandlerV1.UsersPresenceHandlerV1Builder(namespace=" + this.namespace + ", countOnly=" + this.countOnly + ", userIds=" + this.userIds + ")";
        }
    }
}

