/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.lobby.operations.party;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.lobby.models.ModelsPartyData;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminGetPartyDataV1
extends Operation {
    private String path = "/lobby/v1/admin/party/namespaces/{namespace}/parties/{partyId}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String partyId;

    @Deprecated
    public AdminGetPartyDataV1(String namespace, String partyId) {
        this.namespace = namespace;
        this.partyId = partyId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.partyId != null) {
            pathParams.put("partyId", this.partyId);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.partyId != null;
    }

    public ModelsPartyData parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsPartyData().createFromJson(json);
    }

    public static AdminGetPartyDataV1Builder builder() {
        return new AdminGetPartyDataV1Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPartyId() {
        return this.partyId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPartyId(String partyId) {
        this.partyId = partyId;
    }

    public static class AdminGetPartyDataV1Builder {
        private String namespace;
        private String partyId;

        AdminGetPartyDataV1Builder() {
        }

        public AdminGetPartyDataV1Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminGetPartyDataV1Builder partyId(String partyId) {
            this.partyId = partyId;
            return this;
        }

        public AdminGetPartyDataV1 build() {
            return new AdminGetPartyDataV1(this.namespace, this.partyId);
        }

        public String toString() {
            return "AdminGetPartyDataV1.AdminGetPartyDataV1Builder(namespace=" + this.namespace + ", partyId=" + this.partyId + ")";
        }
    }
}

