/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.lobby.operations.notification;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.lobby.models.ModelNotificationResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetMyNotifications
extends Operation {
    private String path = "/notification/namespaces/{namespace}/me";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private Integer endTime;
    private Integer limit;
    private Integer offset;
    private Integer startTime;

    @Deprecated
    public GetMyNotifications(String namespace, Integer endTime, Integer limit, Integer offset, Integer startTime) {
        this.namespace = namespace;
        this.endTime = endTime;
        this.limit = limit;
        this.offset = offset;
        this.startTime = startTime;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("endTime", this.endTime == null ? null : Arrays.asList(String.valueOf(this.endTime)));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("startTime", this.startTime == null ? null : Arrays.asList(String.valueOf(this.startTime)));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public ModelNotificationResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelNotificationResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("endTime", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("startTime", "None");
        return result;
    }

    public static GetMyNotificationsBuilder builder() {
        return new GetMyNotificationsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Integer getEndTime() {
        return this.endTime;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getStartTime() {
        return this.startTime;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setEndTime(Integer endTime) {
        this.endTime = endTime;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setStartTime(Integer startTime) {
        this.startTime = startTime;
    }

    public static class GetMyNotificationsBuilder {
        private String namespace;
        private Integer endTime;
        private Integer limit;
        private Integer offset;
        private Integer startTime;

        GetMyNotificationsBuilder() {
        }

        public GetMyNotificationsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetMyNotificationsBuilder endTime(Integer endTime) {
            this.endTime = endTime;
            return this;
        }

        public GetMyNotificationsBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetMyNotificationsBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public GetMyNotificationsBuilder startTime(Integer startTime) {
            this.startTime = startTime;
            return this;
        }

        public GetMyNotifications build() {
            return new GetMyNotifications(this.namespace, this.endTime, this.limit, this.offset, this.startTime);
        }

        public String toString() {
            return "GetMyNotifications.GetMyNotificationsBuilder(namespace=" + this.namespace + ", endTime=" + this.endTime + ", limit=" + this.limit + ", offset=" + this.offset + ", startTime=" + this.startTime + ")";
        }
    }
}

