/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.lobby.operations.friends;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.lobby.models.ModelFriendshipConnectionResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminListFriendsOfFriends
extends Operation {
    private String path = "/lobby/v1/admin/friend/namespaces/{namespace}/users/{userId}/of-friends";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private String friendId;
    private Integer limit;
    private Boolean nopaging;
    private Integer offset;

    @Deprecated
    public AdminListFriendsOfFriends(String namespace, String userId, String friendId, Integer limit, Boolean nopaging, Integer offset) {
        this.namespace = namespace;
        this.userId = userId;
        this.friendId = friendId;
        this.limit = limit;
        this.nopaging = nopaging;
        this.offset = offset;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("friendId", this.friendId == null ? null : Arrays.asList(this.friendId));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("nopaging", this.nopaging == null ? null : Arrays.asList(String.valueOf(this.nopaging)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public ModelFriendshipConnectionResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelFriendshipConnectionResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("friendId", "None");
        result.put("limit", "None");
        result.put("nopaging", "None");
        result.put("offset", "None");
        return result;
    }

    public static AdminListFriendsOfFriendsBuilder builder() {
        return new AdminListFriendsOfFriendsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getFriendId() {
        return this.friendId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Boolean getNopaging() {
        return this.nopaging;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setFriendId(String friendId) {
        this.friendId = friendId;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setNopaging(Boolean nopaging) {
        this.nopaging = nopaging;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public static class AdminListFriendsOfFriendsBuilder {
        private String namespace;
        private String userId;
        private String friendId;
        private Integer limit;
        private Boolean nopaging;
        private Integer offset;

        AdminListFriendsOfFriendsBuilder() {
        }

        public AdminListFriendsOfFriendsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminListFriendsOfFriendsBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public AdminListFriendsOfFriendsBuilder friendId(String friendId) {
            this.friendId = friendId;
            return this;
        }

        public AdminListFriendsOfFriendsBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public AdminListFriendsOfFriendsBuilder nopaging(Boolean nopaging) {
            this.nopaging = nopaging;
            return this;
        }

        public AdminListFriendsOfFriendsBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public AdminListFriendsOfFriends build() {
            return new AdminListFriendsOfFriends(this.namespace, this.userId, this.friendId, this.limit, this.nopaging, this.offset);
        }

        public String toString() {
            return "AdminListFriendsOfFriends.AdminListFriendsOfFriendsBuilder(namespace=" + this.namespace + ", userId=" + this.userId + ", friendId=" + this.friendId + ", limit=" + this.limit + ", nopaging=" + this.nopaging + ", offset=" + this.offset + ")";
        }
    }
}

