/*
 * Copyright (c) 2022 AccelByte Inc. All Rights Reserved
 * This is licensed software from AccelByte Inc, for limitations
 * and restrictions contact your company contract manager.
 *
 * Code generated. DO NOT EDIT.
 */

package net.accelbyte.sdk.api.lobby.operations.friends;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.*;
import java.util.*;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import net.accelbyte.sdk.api.lobby.models.*;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

/**
 * syncNativeFriends
 *
 * <p>Sync friends using server to server call to native first party server. Supported platforms:
 * steam: The platform_tokenâs value is the binary ticket returned by Steam. If this ticket was
 * generated by Steam GetAuthTicketForWebApi with version >= 1.57, then platform token should use
 * this style: {identity}:{ticket} the {identity} was the parameter to call GetAuthTicketForWebApi
 * when the ticket was created. Note: Do not contain : in this {identity} ps4: The
 * platform_tokenâs value is the authorization code returned by Sony OAuth. ps5: The
 * platform_tokenâs value is the authorization code returned by Sony OAuth. pspc: The
 * platform_tokenâs value is the authorization code returned by Sony OAuth.
 */
@Getter
@Setter
public class SyncNativeFriends extends Operation {
  /** generated field's value */
  private String path = "/friends/sync/namespaces/{namespace}/me";

  private String method = "PATCH";
  private List<String> consumes = Arrays.asList("application/json");
  private List<String> produces = Arrays.asList("application/json");
  private String locationQuery = null;

  /** fields as input parameter */
  private String namespace;

  private List<ModelNativeFriendRequest> body;

  /**
   * @param namespace required
   * @param body required
   */
  @Builder
  // @deprecated 2022-08-29 - All args constructor may cause problems. Use builder instead.
  @Deprecated
  public SyncNativeFriends(String namespace, List<ModelNativeFriendRequest> body) {
    this.namespace = namespace;
    this.body = body;

    securities.add("Bearer");
  }

  @Override
  public Map<String, String> getPathParams() {
    Map<String, String> pathParams = new HashMap<>();
    if (this.namespace != null) {
      pathParams.put("namespace", this.namespace);
    }
    return pathParams;
  }

  @Override
  public List<ModelNativeFriendRequest> getBodyParams() {
    return this.body;
  }

  @Override
  public boolean isValid() {
    if (this.namespace == null) {
      return false;
    }
    return true;
  }

  public List<ModelNativeFriendSyncResponse> parseResponse(
      int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
    if (code != 200) {
      final String json = Helper.convertInputStreamToString(payload);
      throw new HttpResponseException(code, json);
    }
    final String json = Helper.convertInputStreamToString(payload);
    return new ObjectMapper()
        .readValue(json, new TypeReference<List<ModelNativeFriendSyncResponse>>() {});
  }
}
