/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.lobby.ws_models;

import java.util.HashMap;
import java.util.Map;
import net.accelbyte.sdk.core.util.Helper;

public class UserMetricResponse {
    private Integer code;
    private String id;
    private Integer playerCount;

    private UserMetricResponse() {
    }

    @Deprecated
    public UserMetricResponse(Integer code, String id, Integer playerCount) {
        this.code = code;
        this.id = id;
        this.playerCount = playerCount;
    }

    public static String getType() {
        return "userMetricResponse";
    }

    public static UserMetricResponse createFromWSM(String message) {
        UserMetricResponse result = new UserMetricResponse();
        Map response = Helper.parseWSM((String)message);
        result.code = response.get("code") != null ? Integer.valueOf((String)response.get("code")) : null;
        result.id = response.get("id") != null ? (String)response.get("id") : null;
        result.playerCount = response.get("playerCount") != null ? Integer.valueOf((String)response.get("playerCount")) : null;
        return result;
    }

    public String toWSM() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("type: ").append(UserMetricResponse.getType());
        if (this.code != null) {
            stringBuilder.append("\n").append("code: ").append(this.code);
        }
        if (this.id != null) {
            stringBuilder.append("\n").append("id: ").append(this.id);
        } else {
            stringBuilder.append("\n").append("id: ").append(Helper.generateUUID());
        }
        if (this.playerCount != null) {
            stringBuilder.append("\n").append("playerCount: ").append(this.playerCount);
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> getFieldInfo() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("code", "code");
        result.put("id", "id");
        result.put("playerCount", "playerCount");
        return result;
    }

    public static UserMetricResponseBuilder builder() {
        return new UserMetricResponseBuilder();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getId() {
        return this.id;
    }

    public Integer getPlayerCount() {
        return this.playerCount;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPlayerCount(Integer playerCount) {
        this.playerCount = playerCount;
    }

    public static class UserMetricResponseBuilder {
        private Integer code;
        private String id;
        private Integer playerCount;

        UserMetricResponseBuilder() {
        }

        public UserMetricResponseBuilder code(Integer code) {
            this.code = code;
            return this;
        }

        public UserMetricResponseBuilder id(String id) {
            this.id = id;
            return this;
        }

        public UserMetricResponseBuilder playerCount(Integer playerCount) {
            this.playerCount = playerCount;
            return this;
        }

        public UserMetricResponse build() {
            return new UserMetricResponse(this.code, this.id, this.playerCount);
        }

        public String toString() {
            return "UserMetricResponse.UserMetricResponseBuilder(code=" + this.code + ", id=" + this.id + ", playerCount=" + this.playerCount + ")";
        }
    }
}

