/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.lobby.ws_models;

import java.util.HashMap;
import java.util.Map;
import net.accelbyte.sdk.core.util.Helper;

public class SendChannelChatRequest {
    private String channelSlug;
    private String id;
    private String payload;

    private SendChannelChatRequest() {
    }

    @Deprecated
    public SendChannelChatRequest(String channelSlug, String id, String payload) {
        this.channelSlug = channelSlug;
        this.id = id;
        this.payload = payload;
    }

    public static String getType() {
        return "sendChannelChatRequest";
    }

    public static SendChannelChatRequest createFromWSM(String message) {
        SendChannelChatRequest result = new SendChannelChatRequest();
        Map response = Helper.parseWSM((String)message);
        result.channelSlug = response.get("channelSlug") != null ? (String)response.get("channelSlug") : null;
        result.id = response.get("id") != null ? (String)response.get("id") : null;
        result.payload = response.get("payload") != null ? (String)response.get("payload") : null;
        return result;
    }

    public String toWSM() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("type: ").append(SendChannelChatRequest.getType());
        if (this.channelSlug != null) {
            stringBuilder.append("\n").append("channelSlug: ").append(this.channelSlug);
        }
        if (this.id != null) {
            stringBuilder.append("\n").append("id: ").append(this.id);
        } else {
            stringBuilder.append("\n").append("id: ").append(Helper.generateUUID());
        }
        if (this.payload != null) {
            stringBuilder.append("\n").append("payload: ").append(this.payload);
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> getFieldInfo() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("channelSlug", "channelSlug");
        result.put("id", "id");
        result.put("payload", "payload");
        return result;
    }

    public static SendChannelChatRequestBuilder builder() {
        return new SendChannelChatRequestBuilder();
    }

    public String getChannelSlug() {
        return this.channelSlug;
    }

    public String getId() {
        return this.id;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setChannelSlug(String channelSlug) {
        this.channelSlug = channelSlug;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public static class SendChannelChatRequestBuilder {
        private String channelSlug;
        private String id;
        private String payload;

        SendChannelChatRequestBuilder() {
        }

        public SendChannelChatRequestBuilder channelSlug(String channelSlug) {
            this.channelSlug = channelSlug;
            return this;
        }

        public SendChannelChatRequestBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SendChannelChatRequestBuilder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public SendChannelChatRequest build() {
            return new SendChannelChatRequest(this.channelSlug, this.id, this.payload);
        }

        public String toString() {
            return "SendChannelChatRequest.SendChannelChatRequestBuilder(channelSlug=" + this.channelSlug + ", id=" + this.id + ", payload=" + this.payload + ")";
        }
    }
}

