/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.lobby.ws_models;

import java.util.HashMap;
import java.util.Map;
import net.accelbyte.sdk.core.util.Helper;

public class PartyChatRequest {
    private String from;
    private String id;
    private String payload;
    private Integer receivedAt;
    private String to;

    private PartyChatRequest() {
    }

    @Deprecated
    public PartyChatRequest(String from, String id, String payload, Integer receivedAt, String to) {
        this.from = from;
        this.id = id;
        this.payload = payload;
        this.receivedAt = receivedAt;
        this.to = to;
    }

    public static String getType() {
        return "partyChatRequest";
    }

    public static PartyChatRequest createFromWSM(String message) {
        PartyChatRequest result = new PartyChatRequest();
        Map response = Helper.parseWSM((String)message);
        result.from = response.get("from") != null ? (String)response.get("from") : null;
        result.id = response.get("id") != null ? (String)response.get("id") : null;
        result.payload = response.get("payload") != null ? (String)response.get("payload") : null;
        result.receivedAt = response.get("receivedAt") != null ? Integer.valueOf((String)response.get("receivedAt")) : null;
        result.to = response.get("to") != null ? (String)response.get("to") : null;
        return result;
    }

    public String toWSM() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("type: ").append(PartyChatRequest.getType());
        if (this.from != null) {
            stringBuilder.append("\n").append("from: ").append(this.from);
        }
        if (this.id != null) {
            stringBuilder.append("\n").append("id: ").append(this.id);
        } else {
            stringBuilder.append("\n").append("id: ").append(Helper.generateUUID());
        }
        if (this.payload != null) {
            stringBuilder.append("\n").append("payload: ").append(this.payload);
        }
        if (this.receivedAt != null) {
            stringBuilder.append("\n").append("receivedAt: ").append(this.receivedAt);
        }
        if (this.to != null) {
            stringBuilder.append("\n").append("to: ").append(this.to);
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> getFieldInfo() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("from", "from");
        result.put("id", "id");
        result.put("payload", "payload");
        result.put("receivedAt", "receivedAt");
        result.put("to", "to");
        return result;
    }

    public static PartyChatRequestBuilder builder() {
        return new PartyChatRequestBuilder();
    }

    public String getFrom() {
        return this.from;
    }

    public String getId() {
        return this.id;
    }

    public String getPayload() {
        return this.payload;
    }

    public Integer getReceivedAt() {
        return this.receivedAt;
    }

    public String getTo() {
        return this.to;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setReceivedAt(Integer receivedAt) {
        this.receivedAt = receivedAt;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public static class PartyChatRequestBuilder {
        private String from;
        private String id;
        private String payload;
        private Integer receivedAt;
        private String to;

        PartyChatRequestBuilder() {
        }

        public PartyChatRequestBuilder from(String from) {
            this.from = from;
            return this;
        }

        public PartyChatRequestBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PartyChatRequestBuilder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public PartyChatRequestBuilder receivedAt(Integer receivedAt) {
            this.receivedAt = receivedAt;
            return this;
        }

        public PartyChatRequestBuilder to(String to) {
            this.to = to;
            return this;
        }

        public PartyChatRequest build() {
            return new PartyChatRequest(this.from, this.id, this.payload, this.receivedAt, this.to);
        }

        public String toString() {
            return "PartyChatRequest.PartyChatRequestBuilder(from=" + this.from + ", id=" + this.id + ", payload=" + this.payload + ", receivedAt=" + this.receivedAt + ", to=" + this.to + ")";
        }
    }
}

