/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.lobby.ws_models;

import java.util.HashMap;
import java.util.Map;
import net.accelbyte.sdk.core.util.Helper;

public class MessageNotif {
    private String from;
    private String id;
    private String payload;
    private Integer sentAt;
    private String to;
    private String topic;

    private MessageNotif() {
    }

    @Deprecated
    public MessageNotif(String from, String id, String payload, Integer sentAt, String to, String topic) {
        this.from = from;
        this.id = id;
        this.payload = payload;
        this.sentAt = sentAt;
        this.to = to;
        this.topic = topic;
    }

    public static String getType() {
        return "messageNotif";
    }

    public static MessageNotif createFromWSM(String message) {
        MessageNotif result = new MessageNotif();
        Map response = Helper.parseWSM((String)message);
        result.from = response.get("from") != null ? (String)response.get("from") : null;
        result.id = response.get("id") != null ? (String)response.get("id") : null;
        result.payload = response.get("payload") != null ? (String)response.get("payload") : null;
        result.sentAt = response.get("sentAt") != null ? Integer.valueOf((String)response.get("sentAt")) : null;
        result.to = response.get("to") != null ? (String)response.get("to") : null;
        result.topic = response.get("topic") != null ? (String)response.get("topic") : null;
        return result;
    }

    public String toWSM() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("type: ").append(MessageNotif.getType());
        if (this.from != null) {
            stringBuilder.append("\n").append("from: ").append(this.from);
        }
        if (this.id != null) {
            stringBuilder.append("\n").append("id: ").append(this.id);
        } else {
            stringBuilder.append("\n").append("id: ").append(Helper.generateUUID());
        }
        if (this.payload != null) {
            stringBuilder.append("\n").append("payload: ").append(this.payload);
        }
        if (this.sentAt != null) {
            stringBuilder.append("\n").append("sentAt: ").append(this.sentAt);
        }
        if (this.to != null) {
            stringBuilder.append("\n").append("to: ").append(this.to);
        }
        if (this.topic != null) {
            stringBuilder.append("\n").append("topic: ").append(this.topic);
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> getFieldInfo() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("from", "from");
        result.put("id", "id");
        result.put("payload", "payload");
        result.put("sentAt", "sentAt");
        result.put("to", "to");
        result.put("topic", "topic");
        return result;
    }

    public static MessageNotifBuilder builder() {
        return new MessageNotifBuilder();
    }

    public String getFrom() {
        return this.from;
    }

    public String getId() {
        return this.id;
    }

    public String getPayload() {
        return this.payload;
    }

    public Integer getSentAt() {
        return this.sentAt;
    }

    public String getTo() {
        return this.to;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setSentAt(Integer sentAt) {
        this.sentAt = sentAt;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public static class MessageNotifBuilder {
        private String from;
        private String id;
        private String payload;
        private Integer sentAt;
        private String to;
        private String topic;

        MessageNotifBuilder() {
        }

        public MessageNotifBuilder from(String from) {
            this.from = from;
            return this;
        }

        public MessageNotifBuilder id(String id) {
            this.id = id;
            return this;
        }

        public MessageNotifBuilder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public MessageNotifBuilder sentAt(Integer sentAt) {
            this.sentAt = sentAt;
            return this;
        }

        public MessageNotifBuilder to(String to) {
            this.to = to;
            return this;
        }

        public MessageNotifBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public MessageNotif build() {
            return new MessageNotif(this.from, this.id, this.payload, this.sentAt, this.to, this.topic);
        }

        public String toString() {
            return "MessageNotif.MessageNotifBuilder(from=" + this.from + ", id=" + this.id + ", payload=" + this.payload + ", sentAt=" + this.sentAt + ", to=" + this.to + ", topic=" + this.topic + ")";
        }
    }
}

