/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.lobby.ws_models;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.util.Helper;

public class FriendsStatusResponse {
    private List<String> activity;
    private List<String> availability;
    private Integer code;
    private List<String> friendIds;
    private String id;
    private List<String> lastSeenAt;

    private FriendsStatusResponse() {
    }

    @Deprecated
    public FriendsStatusResponse(List<String> activity, List<String> availability, Integer code, List<String> friendIds, String id, List<String> lastSeenAt) {
        this.activity = activity;
        this.availability = availability;
        this.code = code;
        this.friendIds = friendIds;
        this.id = id;
        this.lastSeenAt = lastSeenAt;
    }

    public static String getType() {
        return "friendsStatusResponse";
    }

    public static FriendsStatusResponse createFromWSM(String message) {
        FriendsStatusResponse result = new FriendsStatusResponse();
        Map response = Helper.parseWSM((String)message);
        result.activity = response.get("activity") != null ? Helper.convertWSMListToListString((String)((String)response.get("activity"))) : null;
        result.availability = response.get("availability") != null ? Helper.convertWSMListToListString((String)((String)response.get("availability"))) : null;
        result.code = response.get("code") != null ? Integer.valueOf((String)response.get("code")) : null;
        result.friendIds = response.get("friendIds") != null ? Helper.convertWSMListToListString((String)((String)response.get("friendIds"))) : null;
        result.id = response.get("id") != null ? (String)response.get("id") : null;
        result.lastSeenAt = response.get("lastSeenAt") != null ? Helper.convertWSMListToListString((String)((String)response.get("lastSeenAt"))) : null;
        return result;
    }

    public String toWSM() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("type: ").append(FriendsStatusResponse.getType());
        if (this.activity != null) {
            stringBuilder.append("\n").append("activity: ").append(Helper.listToWSMList(this.activity));
        }
        if (this.availability != null) {
            stringBuilder.append("\n").append("availability: ").append(Helper.listToWSMList(this.availability));
        }
        if (this.code != null) {
            stringBuilder.append("\n").append("code: ").append(this.code);
        }
        if (this.friendIds != null) {
            stringBuilder.append("\n").append("friendIds: ").append(Helper.listToWSMList(this.friendIds));
        }
        if (this.id != null) {
            stringBuilder.append("\n").append("id: ").append(this.id);
        } else {
            stringBuilder.append("\n").append("id: ").append(Helper.generateUUID());
        }
        if (this.lastSeenAt != null) {
            stringBuilder.append("\n").append("lastSeenAt: ").append(Helper.listToWSMList(this.lastSeenAt));
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> getFieldInfo() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("activity", "activity");
        result.put("availability", "availability");
        result.put("code", "code");
        result.put("friendIds", "friendIds");
        result.put("id", "id");
        result.put("lastSeenAt", "lastSeenAt");
        return result;
    }

    public static FriendsStatusResponseBuilder builder() {
        return new FriendsStatusResponseBuilder();
    }

    public List<String> getActivity() {
        return this.activity;
    }

    public List<String> getAvailability() {
        return this.availability;
    }

    public Integer getCode() {
        return this.code;
    }

    public List<String> getFriendIds() {
        return this.friendIds;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getLastSeenAt() {
        return this.lastSeenAt;
    }

    public void setActivity(List<String> activity) {
        this.activity = activity;
    }

    public void setAvailability(List<String> availability) {
        this.availability = availability;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setFriendIds(List<String> friendIds) {
        this.friendIds = friendIds;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLastSeenAt(List<String> lastSeenAt) {
        this.lastSeenAt = lastSeenAt;
    }

    public static class FriendsStatusResponseBuilder {
        private List<String> activity;
        private List<String> availability;
        private Integer code;
        private List<String> friendIds;
        private String id;
        private List<String> lastSeenAt;

        FriendsStatusResponseBuilder() {
        }

        public FriendsStatusResponseBuilder activity(List<String> activity) {
            this.activity = activity;
            return this;
        }

        public FriendsStatusResponseBuilder availability(List<String> availability) {
            this.availability = availability;
            return this;
        }

        public FriendsStatusResponseBuilder code(Integer code) {
            this.code = code;
            return this;
        }

        public FriendsStatusResponseBuilder friendIds(List<String> friendIds) {
            this.friendIds = friendIds;
            return this;
        }

        public FriendsStatusResponseBuilder id(String id) {
            this.id = id;
            return this;
        }

        public FriendsStatusResponseBuilder lastSeenAt(List<String> lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
            return this;
        }

        public FriendsStatusResponse build() {
            return new FriendsStatusResponse(this.activity, this.availability, this.code, this.friendIds, this.id, this.lastSeenAt);
        }

        public String toString() {
            return "FriendsStatusResponse.FriendsStatusResponseBuilder(activity=" + this.activity + ", availability=" + this.availability + ", code=" + this.code + ", friendIds=" + this.friendIds + ", id=" + this.id + ", lastSeenAt=" + this.lastSeenAt + ")";
        }
    }
}

