/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.legal.wrappers;

import java.util.List;
import net.accelbyte.sdk.api.legal.models.RetrieveUserInfoCacheStatusResponse;
import net.accelbyte.sdk.api.legal.operations.user_info.GetUserInfoStatus;
import net.accelbyte.sdk.api.legal.operations.user_info.InvalidateUserInfoCache;
import net.accelbyte.sdk.api.legal.operations.user_info.SyncUserInfo;
import net.accelbyte.sdk.core.HttpResponse;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.RequestRunner;

public class UserInfo {
    private RequestRunner sdk;
    private String customBasePath = "";

    public UserInfo(RequestRunner sdk) {
        this.sdk = sdk;
        String configCustomBasePath = sdk.getSdkConfiguration().getConfigRepository().getCustomServiceBasePath("legal");
        if (!configCustomBasePath.equals("")) {
            this.customBasePath = configCustomBasePath;
        }
    }

    public UserInfo(RequestRunner sdk, String customBasePath) {
        this.sdk = sdk;
        this.customBasePath = customBasePath;
    }

    public List<RetrieveUserInfoCacheStatusResponse> getUserInfoStatus(GetUserInfoStatus input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    @Deprecated
    public void syncUserInfo(SyncUserInfo input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        input.handleEmptyResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    @Deprecated
    public void invalidateUserInfoCache(InvalidateUserInfoCache input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        input.handleEmptyResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }
}

