/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.legal.wrappers;

import java.util.List;
import net.accelbyte.sdk.api.legal.models.RetrievePolicyPublicResponse;
import net.accelbyte.sdk.api.legal.models.RetrievePolicyResponse;
import net.accelbyte.sdk.api.legal.operations.policies.RetrieveCountryListWithPolicies;
import net.accelbyte.sdk.api.legal.operations.policies.RetrieveLatestPolicies;
import net.accelbyte.sdk.api.legal.operations.policies.RetrieveLatestPoliciesByNamespaceAndCountryPublic;
import net.accelbyte.sdk.api.legal.operations.policies.RetrieveLatestPoliciesPublic;
import net.accelbyte.sdk.api.legal.operations.policies.RetrievePolicies;
import net.accelbyte.sdk.api.legal.operations.policies.SetDefaultPolicy2;
import net.accelbyte.sdk.api.legal.operations.policies.UpdatePolicy;
import net.accelbyte.sdk.core.HttpResponse;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.RequestRunner;

public class Policies {
    private RequestRunner sdk;
    private String customBasePath = "";

    public Policies(RequestRunner sdk) {
        this.sdk = sdk;
        String configCustomBasePath = sdk.getSdkConfiguration().getConfigRepository().getCustomServiceBasePath("legal");
        if (!configCustomBasePath.equals("")) {
            this.customBasePath = configCustomBasePath;
        }
    }

    public Policies(RequestRunner sdk, String customBasePath) {
        this.sdk = sdk;
        this.customBasePath = customBasePath;
    }

    public List<RetrievePolicyResponse> retrievePolicies(RetrievePolicies input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public void updatePolicy(UpdatePolicy input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        input.handleEmptyResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public void setDefaultPolicy2(SetDefaultPolicy2 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        input.handleEmptyResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public List<String> retrieveCountryListWithPolicies(RetrieveCountryListWithPolicies input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public List<RetrievePolicyPublicResponse> retrieveLatestPolicies(RetrieveLatestPolicies input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public List<RetrievePolicyPublicResponse> retrieveLatestPoliciesPublic(RetrieveLatestPoliciesPublic input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public List<RetrievePolicyPublicResponse> retrieveLatestPoliciesByNamespaceAndCountryPublic(RetrieveLatestPoliciesByNamespaceAndCountryPublic input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }
}

