/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.legal.operations.policies;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.legal.models.RetrievePolicyPublicResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class RetrieveLatestPoliciesPublic
extends Operation {
    private String path = "/agreement/public/policies/namespaces/{namespace}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private Boolean alwaysIncludeDefault;
    private Boolean defaultOnEmpty;
    private String policyType;
    private String tags;
    private Boolean visibleOnly;

    @Deprecated
    public RetrieveLatestPoliciesPublic(String customBasePath, String namespace, Boolean alwaysIncludeDefault, Boolean defaultOnEmpty, String policyType, String tags, Boolean visibleOnly) {
        this.namespace = namespace;
        this.alwaysIncludeDefault = alwaysIncludeDefault;
        this.defaultOnEmpty = defaultOnEmpty;
        this.policyType = policyType;
        this.tags = tags;
        this.visibleOnly = visibleOnly;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("alwaysIncludeDefault", this.alwaysIncludeDefault == null ? null : Arrays.asList(String.valueOf(this.alwaysIncludeDefault)));
        queryParams.put("defaultOnEmpty", this.defaultOnEmpty == null ? null : Arrays.asList(String.valueOf(this.defaultOnEmpty)));
        queryParams.put("policyType", this.policyType == null ? null : Arrays.asList(this.policyType));
        queryParams.put("tags", this.tags == null ? null : Arrays.asList(this.tags));
        queryParams.put("visibleOnly", this.visibleOnly == null ? null : Arrays.asList(String.valueOf(this.visibleOnly)));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public List<RetrievePolicyPublicResponse> parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<RetrievePolicyPublicResponse>>(){});
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("alwaysIncludeDefault", "None");
        result.put("defaultOnEmpty", "None");
        result.put("policyType", "None");
        result.put("tags", "None");
        result.put("visibleOnly", "None");
        return result;
    }

    public static RetrieveLatestPoliciesPublicBuilder builder() {
        return new RetrieveLatestPoliciesPublicBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Boolean getAlwaysIncludeDefault() {
        return this.alwaysIncludeDefault;
    }

    public Boolean getDefaultOnEmpty() {
        return this.defaultOnEmpty;
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public String getTags() {
        return this.tags;
    }

    public Boolean getVisibleOnly() {
        return this.visibleOnly;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setAlwaysIncludeDefault(Boolean alwaysIncludeDefault) {
        this.alwaysIncludeDefault = alwaysIncludeDefault;
    }

    public void setDefaultOnEmpty(Boolean defaultOnEmpty) {
        this.defaultOnEmpty = defaultOnEmpty;
    }

    public void setPolicyType(String policyType) {
        this.policyType = policyType;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public void setVisibleOnly(Boolean visibleOnly) {
        this.visibleOnly = visibleOnly;
    }

    public static class RetrieveLatestPoliciesPublicBuilder {
        private String customBasePath;
        private String namespace;
        private Boolean alwaysIncludeDefault;
        private Boolean defaultOnEmpty;
        private String tags;
        private Boolean visibleOnly;
        private String policyType;

        public RetrieveLatestPoliciesPublicBuilder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        public RetrieveLatestPoliciesPublicBuilder policyTypeFromEnum(PolicyType policyType) {
            this.policyType = policyType.toString();
            return this;
        }

        RetrieveLatestPoliciesPublicBuilder() {
        }

        public RetrieveLatestPoliciesPublicBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public RetrieveLatestPoliciesPublicBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public RetrieveLatestPoliciesPublicBuilder alwaysIncludeDefault(Boolean alwaysIncludeDefault) {
            this.alwaysIncludeDefault = alwaysIncludeDefault;
            return this;
        }

        public RetrieveLatestPoliciesPublicBuilder defaultOnEmpty(Boolean defaultOnEmpty) {
            this.defaultOnEmpty = defaultOnEmpty;
            return this;
        }

        public RetrieveLatestPoliciesPublicBuilder tags(String tags) {
            this.tags = tags;
            return this;
        }

        public RetrieveLatestPoliciesPublicBuilder visibleOnly(Boolean visibleOnly) {
            this.visibleOnly = visibleOnly;
            return this;
        }

        public RetrieveLatestPoliciesPublic build() {
            return new RetrieveLatestPoliciesPublic(this.customBasePath, this.namespace, this.alwaysIncludeDefault, this.defaultOnEmpty, this.policyType, this.tags, this.visibleOnly);
        }

        public String toString() {
            return "RetrieveLatestPoliciesPublic.RetrieveLatestPoliciesPublicBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", alwaysIncludeDefault=" + this.alwaysIncludeDefault + ", defaultOnEmpty=" + this.defaultOnEmpty + ", policyType=" + this.policyType + ", tags=" + this.tags + ", visibleOnly=" + this.visibleOnly + ")";
        }
    }

    public static enum PolicyType {
        LEGALDOCUMENTTYPE("LEGAL_DOCUMENT_TYPE"),
        MARKETINGPREFERENCETYPE("MARKETING_PREFERENCE_TYPE");

        private String value;

        private PolicyType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

