/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.legal.operations.policies;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.legal.models.RetrievePolicyPublicResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class RetrieveLatestPoliciesByNamespaceAndCountryPublic
extends Operation {
    private String path = "/agreement/public/policies/namespaces/{namespace}/countries/{countryCode}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String countryCode;
    private String namespace;
    private Boolean alwaysIncludeDefault;
    private Boolean defaultOnEmpty;
    private String policyType;
    private String tags;
    private Boolean visibleOnly;

    @Deprecated
    public RetrieveLatestPoliciesByNamespaceAndCountryPublic(String customBasePath, String countryCode, String namespace, Boolean alwaysIncludeDefault, Boolean defaultOnEmpty, String policyType, String tags, Boolean visibleOnly) {
        this.countryCode = countryCode;
        this.namespace = namespace;
        this.alwaysIncludeDefault = alwaysIncludeDefault;
        this.defaultOnEmpty = defaultOnEmpty;
        this.policyType = policyType;
        this.tags = tags;
        this.visibleOnly = visibleOnly;
        this.customBasePath = customBasePath != null ? customBasePath : "";
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.countryCode != null) {
            pathParams.put("countryCode", this.countryCode);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("alwaysIncludeDefault", this.alwaysIncludeDefault == null ? null : Arrays.asList(String.valueOf(this.alwaysIncludeDefault)));
        queryParams.put("defaultOnEmpty", this.defaultOnEmpty == null ? null : Arrays.asList(String.valueOf(this.defaultOnEmpty)));
        queryParams.put("policyType", this.policyType == null ? null : Arrays.asList(this.policyType));
        queryParams.put("tags", this.tags == null ? null : Arrays.asList(this.tags));
        queryParams.put("visibleOnly", this.visibleOnly == null ? null : Arrays.asList(String.valueOf(this.visibleOnly)));
        return queryParams;
    }

    public boolean isValid() {
        if (this.countryCode == null) {
            return false;
        }
        return this.namespace != null;
    }

    public List<RetrievePolicyPublicResponse> parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<RetrievePolicyPublicResponse>>(){});
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("alwaysIncludeDefault", "None");
        result.put("defaultOnEmpty", "None");
        result.put("policyType", "None");
        result.put("tags", "None");
        result.put("visibleOnly", "None");
        return result;
    }

    public static RetrieveLatestPoliciesByNamespaceAndCountryPublicBuilder builder() {
        return new RetrieveLatestPoliciesByNamespaceAndCountryPublicBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Boolean getAlwaysIncludeDefault() {
        return this.alwaysIncludeDefault;
    }

    public Boolean getDefaultOnEmpty() {
        return this.defaultOnEmpty;
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public String getTags() {
        return this.tags;
    }

    public Boolean getVisibleOnly() {
        return this.visibleOnly;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setAlwaysIncludeDefault(Boolean alwaysIncludeDefault) {
        this.alwaysIncludeDefault = alwaysIncludeDefault;
    }

    public void setDefaultOnEmpty(Boolean defaultOnEmpty) {
        this.defaultOnEmpty = defaultOnEmpty;
    }

    public void setPolicyType(String policyType) {
        this.policyType = policyType;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public void setVisibleOnly(Boolean visibleOnly) {
        this.visibleOnly = visibleOnly;
    }

    public static class RetrieveLatestPoliciesByNamespaceAndCountryPublicBuilder {
        private String customBasePath;
        private String countryCode;
        private String namespace;
        private Boolean alwaysIncludeDefault;
        private Boolean defaultOnEmpty;
        private String tags;
        private Boolean visibleOnly;
        private String policyType;

        public RetrieveLatestPoliciesByNamespaceAndCountryPublicBuilder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        public RetrieveLatestPoliciesByNamespaceAndCountryPublicBuilder policyTypeFromEnum(PolicyType policyType) {
            this.policyType = policyType.toString();
            return this;
        }

        RetrieveLatestPoliciesByNamespaceAndCountryPublicBuilder() {
        }

        public RetrieveLatestPoliciesByNamespaceAndCountryPublicBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public RetrieveLatestPoliciesByNamespaceAndCountryPublicBuilder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public RetrieveLatestPoliciesByNamespaceAndCountryPublicBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public RetrieveLatestPoliciesByNamespaceAndCountryPublicBuilder alwaysIncludeDefault(Boolean alwaysIncludeDefault) {
            this.alwaysIncludeDefault = alwaysIncludeDefault;
            return this;
        }

        public RetrieveLatestPoliciesByNamespaceAndCountryPublicBuilder defaultOnEmpty(Boolean defaultOnEmpty) {
            this.defaultOnEmpty = defaultOnEmpty;
            return this;
        }

        public RetrieveLatestPoliciesByNamespaceAndCountryPublicBuilder tags(String tags) {
            this.tags = tags;
            return this;
        }

        public RetrieveLatestPoliciesByNamespaceAndCountryPublicBuilder visibleOnly(Boolean visibleOnly) {
            this.visibleOnly = visibleOnly;
            return this;
        }

        public RetrieveLatestPoliciesByNamespaceAndCountryPublic build() {
            return new RetrieveLatestPoliciesByNamespaceAndCountryPublic(this.customBasePath, this.countryCode, this.namespace, this.alwaysIncludeDefault, this.defaultOnEmpty, this.policyType, this.tags, this.visibleOnly);
        }

        public String toString() {
            return "RetrieveLatestPoliciesByNamespaceAndCountryPublic.RetrieveLatestPoliciesByNamespaceAndCountryPublicBuilder(customBasePath=" + this.customBasePath + ", countryCode=" + this.countryCode + ", namespace=" + this.namespace + ", alwaysIncludeDefault=" + this.alwaysIncludeDefault + ", defaultOnEmpty=" + this.defaultOnEmpty + ", policyType=" + this.policyType + ", tags=" + this.tags + ", visibleOnly=" + this.visibleOnly + ")";
        }
    }

    public static enum PolicyType {
        LEGALDOCUMENTTYPE("LEGAL_DOCUMENT_TYPE"),
        MARKETINGPREFERENCETYPE("MARKETING_PREFERENCE_TYPE");

        private String value;

        private PolicyType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

