/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.legal.operations.admin_user_eligibilities;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.legal.models.RetrieveUserEligibilitiesIndirectResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminRetrieveEligibilities
extends Operation {
    private String path = "/agreement/admin/namespaces/{namespace}/users/{userId}/eligibilities";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private String publisherUserId;
    private String clientId;
    private String countryCode;

    @Deprecated
    public AdminRetrieveEligibilities(String customBasePath, String namespace, String userId, String publisherUserId, String clientId, String countryCode) {
        this.namespace = namespace;
        this.userId = userId;
        this.publisherUserId = publisherUserId;
        this.clientId = clientId;
        this.countryCode = countryCode;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("publisherUserId", this.publisherUserId == null ? null : Arrays.asList(this.publisherUserId));
        queryParams.put("clientId", this.clientId == null ? null : Arrays.asList(this.clientId));
        queryParams.put("countryCode", this.countryCode == null ? null : Arrays.asList(this.countryCode));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.userId == null) {
            return false;
        }
        if (this.clientId == null) {
            return false;
        }
        return this.countryCode != null;
    }

    public RetrieveUserEligibilitiesIndirectResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new RetrieveUserEligibilitiesIndirectResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("publisherUserId", "None");
        result.put("clientId", "None");
        result.put("countryCode", "None");
        return result;
    }

    public static AdminRetrieveEligibilitiesBuilder builder() {
        return new AdminRetrieveEligibilitiesBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPublisherUserId() {
        return this.publisherUserId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setPublisherUserId(String publisherUserId) {
        this.publisherUserId = publisherUserId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public static class AdminRetrieveEligibilitiesBuilder {
        private String customBasePath;
        private String namespace;
        private String userId;
        private String publisherUserId;
        private String clientId;
        private String countryCode;

        AdminRetrieveEligibilitiesBuilder() {
        }

        public AdminRetrieveEligibilitiesBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminRetrieveEligibilitiesBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminRetrieveEligibilitiesBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public AdminRetrieveEligibilitiesBuilder publisherUserId(String publisherUserId) {
            this.publisherUserId = publisherUserId;
            return this;
        }

        public AdminRetrieveEligibilitiesBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public AdminRetrieveEligibilitiesBuilder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public AdminRetrieveEligibilities build() {
            return new AdminRetrieveEligibilities(this.customBasePath, this.namespace, this.userId, this.publisherUserId, this.clientId, this.countryCode);
        }

        public String toString() {
            return "AdminRetrieveEligibilities.AdminRetrieveEligibilitiesBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", userId=" + this.userId + ", publisherUserId=" + this.publisherUserId + ", clientId=" + this.clientId + ", countryCode=" + this.countryCode + ")";
        }
    }
}

