/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.legal.operations.policies;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.legal.models.RetrievePolicyPublicResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class RetrieveLatestPolicies
extends Operation {
    private String path = "/agreement/public/policies/countries/{countryCode}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String countryCode;
    private Boolean defaultOnEmpty;
    private String policyType;
    private String tags;

    @Deprecated
    public RetrieveLatestPolicies(String countryCode, Boolean defaultOnEmpty, String policyType, String tags) {
        this.countryCode = countryCode;
        this.defaultOnEmpty = defaultOnEmpty;
        this.policyType = policyType;
        this.tags = tags;
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.countryCode != null) {
            pathParams.put("countryCode", this.countryCode);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("defaultOnEmpty", this.defaultOnEmpty == null ? null : Arrays.asList(String.valueOf(this.defaultOnEmpty)));
        queryParams.put("policyType", this.policyType == null ? null : Arrays.asList(this.policyType));
        queryParams.put("tags", this.tags == null ? null : Arrays.asList(this.tags));
        return queryParams;
    }

    public boolean isValid() {
        return this.countryCode != null;
    }

    public List<RetrievePolicyPublicResponse> parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<RetrievePolicyPublicResponse>>(){});
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("defaultOnEmpty", "None");
        result.put("policyType", "None");
        result.put("tags", "None");
        return result;
    }

    public static RetrieveLatestPoliciesBuilder builder() {
        return new RetrieveLatestPoliciesBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public Boolean getDefaultOnEmpty() {
        return this.defaultOnEmpty;
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public String getTags() {
        return this.tags;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setDefaultOnEmpty(Boolean defaultOnEmpty) {
        this.defaultOnEmpty = defaultOnEmpty;
    }

    public void setPolicyType(String policyType) {
        this.policyType = policyType;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public static class RetrieveLatestPoliciesBuilder {
        private String countryCode;
        private Boolean defaultOnEmpty;
        private String tags;
        private String policyType;

        public RetrieveLatestPoliciesBuilder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        public RetrieveLatestPoliciesBuilder policyTypeFromEnum(PolicyType policyType) {
            this.policyType = policyType.toString();
            return this;
        }

        RetrieveLatestPoliciesBuilder() {
        }

        public RetrieveLatestPoliciesBuilder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public RetrieveLatestPoliciesBuilder defaultOnEmpty(Boolean defaultOnEmpty) {
            this.defaultOnEmpty = defaultOnEmpty;
            return this;
        }

        public RetrieveLatestPoliciesBuilder tags(String tags) {
            this.tags = tags;
            return this;
        }

        public RetrieveLatestPolicies build() {
            return new RetrieveLatestPolicies(this.countryCode, this.defaultOnEmpty, this.policyType, this.tags);
        }

        public String toString() {
            return "RetrieveLatestPolicies.RetrieveLatestPoliciesBuilder(countryCode=" + this.countryCode + ", defaultOnEmpty=" + this.defaultOnEmpty + ", policyType=" + this.policyType + ", tags=" + this.tags + ")";
        }
    }

    public static enum PolicyType {
        LEGALDOCUMENTTYPE("LEGAL_DOCUMENT_TYPE"),
        MARKETINGPREFERENCETYPE("MARKETING_PREFERENCE_TYPE");

        private String value;

        private PolicyType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

