/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.legal.operations.eligibilities;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.legal.models.RetrieveUserEligibilitiesIndirectResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class RetrieveEligibilitiesPublicIndirect
extends Operation {
    private String path = "/agreement/public/eligibilities/namespaces/{namespace}/countries/{countryCode}/clients/{clientId}/users/{userId}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String clientId;
    private String countryCode;
    private String namespace;
    private String userId;

    @Deprecated
    public RetrieveEligibilitiesPublicIndirect(String clientId, String countryCode, String namespace, String userId) {
        this.clientId = clientId;
        this.countryCode = countryCode;
        this.namespace = namespace;
        this.userId = userId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.clientId != null) {
            pathParams.put("clientId", this.clientId);
        }
        if (this.countryCode != null) {
            pathParams.put("countryCode", this.countryCode);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.clientId == null) {
            return false;
        }
        if (this.countryCode == null) {
            return false;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public RetrieveUserEligibilitiesIndirectResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new RetrieveUserEligibilitiesIndirectResponse().createFromJson(json);
    }

    public static RetrieveEligibilitiesPublicIndirectBuilder builder() {
        return new RetrieveEligibilitiesPublicIndirectBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class RetrieveEligibilitiesPublicIndirectBuilder {
        private String clientId;
        private String countryCode;
        private String namespace;
        private String userId;

        RetrieveEligibilitiesPublicIndirectBuilder() {
        }

        public RetrieveEligibilitiesPublicIndirectBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public RetrieveEligibilitiesPublicIndirectBuilder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public RetrieveEligibilitiesPublicIndirectBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public RetrieveEligibilitiesPublicIndirectBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public RetrieveEligibilitiesPublicIndirect build() {
            return new RetrieveEligibilitiesPublicIndirect(this.clientId, this.countryCode, this.namespace, this.userId);
        }

        public String toString() {
            return "RetrieveEligibilitiesPublicIndirect.RetrieveEligibilitiesPublicIndirectBuilder(clientId=" + this.clientId + ", countryCode=" + this.countryCode + ", namespace=" + this.namespace + ", userId=" + this.userId + ")";
        }
    }
}

