/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.inventory.operations.public_items;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.inventory.models.ApimodelsListItemResp;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicListItems
extends Operation {
    private String path = "/inventory/v1/public/namespaces/{namespace}/users/me/inventories/{inventoryId}/items";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String inventoryId;
    private String namespace;
    private Integer limit;
    private Integer offset;
    private Integer qtyGte;
    private String sortBy;
    private String sourceItemId;
    private String tags;

    @Deprecated
    public PublicListItems(String inventoryId, String namespace, Integer limit, Integer offset, Integer qtyGte, String sortBy, String sourceItemId, String tags) {
        this.inventoryId = inventoryId;
        this.namespace = namespace;
        this.limit = limit;
        this.offset = offset;
        this.qtyGte = qtyGte;
        this.sortBy = sortBy;
        this.sourceItemId = sourceItemId;
        this.tags = tags;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.inventoryId != null) {
            pathParams.put("inventoryId", this.inventoryId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("qtyGte", this.qtyGte == null ? null : Arrays.asList(String.valueOf(this.qtyGte)));
        queryParams.put("sortBy", this.sortBy == null ? null : Arrays.asList(this.sortBy));
        queryParams.put("sourceItemId", this.sourceItemId == null ? null : Arrays.asList(this.sourceItemId));
        queryParams.put("tags", this.tags == null ? null : Arrays.asList(this.tags));
        return queryParams;
    }

    public boolean isValid() {
        if (this.inventoryId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ApimodelsListItemResp parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ApimodelsListItemResp().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("qtyGte", "None");
        result.put("sortBy", "None");
        result.put("sourceItemId", "None");
        result.put("tags", "None");
        return result;
    }

    public static PublicListItemsBuilder builder() {
        return new PublicListItemsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getInventoryId() {
        return this.inventoryId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getQtyGte() {
        return this.qtyGte;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public String getSourceItemId() {
        return this.sourceItemId;
    }

    public String getTags() {
        return this.tags;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setInventoryId(String inventoryId) {
        this.inventoryId = inventoryId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setQtyGte(Integer qtyGte) {
        this.qtyGte = qtyGte;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public void setSourceItemId(String sourceItemId) {
        this.sourceItemId = sourceItemId;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public static class PublicListItemsBuilder {
        private String inventoryId;
        private String namespace;
        private Integer limit;
        private Integer offset;
        private Integer qtyGte;
        private String sourceItemId;
        private String tags;
        private String sortBy;

        public PublicListItemsBuilder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public PublicListItemsBuilder sortByFromEnum(SortBy sortBy) {
            this.sortBy = sortBy.toString();
            return this;
        }

        PublicListItemsBuilder() {
        }

        public PublicListItemsBuilder inventoryId(String inventoryId) {
            this.inventoryId = inventoryId;
            return this;
        }

        public PublicListItemsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicListItemsBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public PublicListItemsBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public PublicListItemsBuilder qtyGte(Integer qtyGte) {
            this.qtyGte = qtyGte;
            return this;
        }

        public PublicListItemsBuilder sourceItemId(String sourceItemId) {
            this.sourceItemId = sourceItemId;
            return this;
        }

        public PublicListItemsBuilder tags(String tags) {
            this.tags = tags;
            return this;
        }

        public PublicListItems build() {
            return new PublicListItems(this.inventoryId, this.namespace, this.limit, this.offset, this.qtyGte, this.sortBy, this.sourceItemId, this.tags);
        }

        public String toString() {
            return "PublicListItems.PublicListItemsBuilder(inventoryId=" + this.inventoryId + ", namespace=" + this.namespace + ", limit=" + this.limit + ", offset=" + this.offset + ", qtyGte=" + this.qtyGte + ", sortBy=" + this.sortBy + ", sourceItemId=" + this.sourceItemId + ", tags=" + this.tags + ")";
        }
    }

    public static enum SortBy {
        CreatedAt("createdAt"),
        CreatedAtasc("createdAt:asc"),
        CreatedAtdesc("createdAt:desc"),
        Qty("qty"),
        Qtyasc("qty:asc"),
        Qtydesc("qty:desc"),
        UpdatedAt("updatedAt"),
        UpdatedAtasc("updatedAt:asc"),
        UpdatedAtdesc("updatedAt:desc");

        private String value;

        private SortBy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

