/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.inventory.operations.public_items;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.inventory.models.ApimodelsMoveItemsReq;
import net.accelbyte.sdk.api.inventory.models.ApimodelsMoveItemsResp;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicMoveMyItems
extends Operation {
    private String path = "/inventory/v1/public/namespaces/{namespace}/users/me/inventories/{inventoryId}/items/movement";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String inventoryId;
    private String namespace;
    private ApimodelsMoveItemsReq body;

    @Deprecated
    public PublicMoveMyItems(String inventoryId, String namespace, ApimodelsMoveItemsReq body) {
        this.inventoryId = inventoryId;
        this.namespace = namespace;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.inventoryId != null) {
            pathParams.put("inventoryId", this.inventoryId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public ApimodelsMoveItemsReq getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.inventoryId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ApimodelsMoveItemsResp parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ApimodelsMoveItemsResp().createFromJson(json);
    }

    public static PublicMoveMyItemsBuilder builder() {
        return new PublicMoveMyItemsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getInventoryId() {
        return this.inventoryId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ApimodelsMoveItemsReq getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setInventoryId(String inventoryId) {
        this.inventoryId = inventoryId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(ApimodelsMoveItemsReq body) {
        this.body = body;
    }

    public static class PublicMoveMyItemsBuilder {
        private String inventoryId;
        private String namespace;
        private ApimodelsMoveItemsReq body;

        PublicMoveMyItemsBuilder() {
        }

        public PublicMoveMyItemsBuilder inventoryId(String inventoryId) {
            this.inventoryId = inventoryId;
            return this;
        }

        public PublicMoveMyItemsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicMoveMyItemsBuilder body(ApimodelsMoveItemsReq body) {
            this.body = body;
            return this;
        }

        public PublicMoveMyItems build() {
            return new PublicMoveMyItems(this.inventoryId, this.namespace, this.body);
        }

        public String toString() {
            return "PublicMoveMyItems.PublicMoveMyItemsBuilder(inventoryId=" + this.inventoryId + ", namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

