/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.inventory.operations.admin_inventories;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.inventory.models.ApimodelsInventoryResp;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminGetInventory
extends Operation {
    private String path = "/inventory/v1/admin/namespaces/{namespace}/inventories/{inventoryId}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String inventoryId;
    private String namespace;

    @Deprecated
    public AdminGetInventory(String inventoryId, String namespace) {
        this.inventoryId = inventoryId;
        this.namespace = namespace;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.inventoryId != null) {
            pathParams.put("inventoryId", this.inventoryId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.inventoryId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ApimodelsInventoryResp parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ApimodelsInventoryResp().createFromJson(json);
    }

    public static AdminGetInventoryBuilder builder() {
        return new AdminGetInventoryBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getInventoryId() {
        return this.inventoryId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setInventoryId(String inventoryId) {
        this.inventoryId = inventoryId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public static class AdminGetInventoryBuilder {
        private String inventoryId;
        private String namespace;

        AdminGetInventoryBuilder() {
        }

        public AdminGetInventoryBuilder inventoryId(String inventoryId) {
            this.inventoryId = inventoryId;
            return this;
        }

        public AdminGetInventoryBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminGetInventory build() {
            return new AdminGetInventory(this.inventoryId, this.namespace);
        }

        public String toString() {
            return "AdminGetInventory.AdminGetInventoryBuilder(inventoryId=" + this.inventoryId + ", namespace=" + this.namespace + ")";
        }
    }
}

