/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.dsmc.operations.pod_config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.dsmc.models.ModelsListPodConfigResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetAllPodConfigClient
extends Operation {
    private String path = "/dsmcontroller/namespaces/{namespace}/configs/pods";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private Integer count;
    private Integer offset;

    @Deprecated
    public GetAllPodConfigClient(String namespace, Integer count, Integer offset) {
        this.namespace = namespace;
        this.count = count;
        this.offset = offset;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("count", this.count == null ? null : Arrays.asList(String.valueOf(this.count)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.count == null) {
            return false;
        }
        return this.offset != null;
    }

    public ModelsListPodConfigResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsListPodConfigResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("count", "None");
        result.put("offset", "None");
        return result;
    }

    public static GetAllPodConfigClientBuilder builder() {
        return new GetAllPodConfigClientBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Integer getCount() {
        return this.count;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public static class GetAllPodConfigClientBuilder {
        private String namespace;
        private Integer count;
        private Integer offset;

        GetAllPodConfigClientBuilder() {
        }

        public GetAllPodConfigClientBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetAllPodConfigClientBuilder count(Integer count) {
            this.count = count;
            return this;
        }

        public GetAllPodConfigClientBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public GetAllPodConfigClient build() {
            return new GetAllPodConfigClient(this.namespace, this.count, this.offset);
        }

        public String toString() {
            return "GetAllPodConfigClient.GetAllPodConfigClientBuilder(namespace=" + this.namespace + ", count=" + this.count + ", offset=" + this.offset + ")";
        }
    }
}

