/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.dsmc.operations.pod_config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.dsmc.models.ModelsCreatePodConfigRequest;
import net.accelbyte.sdk.api.dsmc.models.ModelsPodConfigRecord;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class CreatePodConfig
extends Operation {
    private String path = "/dsmcontroller/admin/namespaces/{namespace}/configs/pods/{name}";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String name;
    private String namespace;
    private ModelsCreatePodConfigRequest body;

    @Deprecated
    public CreatePodConfig(String name, String namespace, ModelsCreatePodConfigRequest body) {
        this.name = name;
        this.namespace = namespace;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.name != null) {
            pathParams.put("name", this.name);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public ModelsCreatePodConfigRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.name == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ModelsPodConfigRecord parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 201) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsPodConfigRecord().createFromJson(json);
    }

    public static CreatePodConfigBuilder builder() {
        return new CreatePodConfigBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ModelsCreatePodConfigRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(ModelsCreatePodConfigRequest body) {
        this.body = body;
    }

    public static class CreatePodConfigBuilder {
        private String name;
        private String namespace;
        private ModelsCreatePodConfigRequest body;

        CreatePodConfigBuilder() {
        }

        public CreatePodConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreatePodConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public CreatePodConfigBuilder body(ModelsCreatePodConfigRequest body) {
            this.body = body;
            return this;
        }

        public CreatePodConfig build() {
            return new CreatePodConfig(this.name, this.namespace, this.body);
        }

        public String toString() {
            return "CreatePodConfig.CreatePodConfigBuilder(name=" + this.name + ", namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

