/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.dsmc.operations.image_config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.dsmc.models.ModelsListImageResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class ListImagesClient
extends Operation {
    private String path = "/dsmcontroller/namespaces/{namespace}/images";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private Integer count;
    private Integer offset;
    private String q;
    private String sortBy;
    private String sortDirection;

    @Deprecated
    public ListImagesClient(String namespace, Integer count, Integer offset, String q, String sortBy, String sortDirection) {
        this.namespace = namespace;
        this.count = count;
        this.offset = offset;
        this.q = q;
        this.sortBy = sortBy;
        this.sortDirection = sortDirection;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("count", this.count == null ? null : Arrays.asList(String.valueOf(this.count)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("q", this.q == null ? null : Arrays.asList(this.q));
        queryParams.put("sortBy", this.sortBy == null ? null : Arrays.asList(this.sortBy));
        queryParams.put("sortDirection", this.sortDirection == null ? null : Arrays.asList(this.sortDirection));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public ModelsListImageResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsListImageResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("count", "None");
        result.put("offset", "None");
        result.put("q", "None");
        result.put("sortBy", "None");
        result.put("sortDirection", "None");
        return result;
    }

    public static ListImagesClientBuilder builder() {
        return new ListImagesClientBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Integer getCount() {
        return this.count;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getQ() {
        return this.q;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public String getSortDirection() {
        return this.sortDirection;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public void setSortDirection(String sortDirection) {
        this.sortDirection = sortDirection;
    }

    public static class ListImagesClientBuilder {
        private String namespace;
        private Integer count;
        private Integer offset;
        private String q;
        private String sortBy;
        private String sortDirection;

        public ListImagesClientBuilder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public ListImagesClientBuilder sortByFromEnum(SortBy sortBy) {
            this.sortBy = sortBy.toString();
            return this;
        }

        public ListImagesClientBuilder sortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        public ListImagesClientBuilder sortDirectionFromEnum(SortDirection sortDirection) {
            this.sortDirection = sortDirection.toString();
            return this;
        }

        ListImagesClientBuilder() {
        }

        public ListImagesClientBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ListImagesClientBuilder count(Integer count) {
            this.count = count;
            return this;
        }

        public ListImagesClientBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public ListImagesClientBuilder q(String q) {
            this.q = q;
            return this;
        }

        public ListImagesClient build() {
            return new ListImagesClient(this.namespace, this.count, this.offset, this.q, this.sortBy, this.sortDirection);
        }

        public String toString() {
            return "ListImagesClient.ListImagesClientBuilder(namespace=" + this.namespace + ", count=" + this.count + ", offset=" + this.offset + ", q=" + this.q + ", sortBy=" + this.sortBy + ", sortDirection=" + this.sortDirection + ")";
        }
    }

    public static enum SortDirection {
        Asc("asc"),
        Desc("desc");

        private String value;

        private SortDirection(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum SortBy {
        CreatedAt("createdAt"),
        UpdatedAt("updatedAt"),
        Version("version");

        private String value;

        private SortBy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

