/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.dsmc.operations.image_config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.dsmc.models.ModelsListImageResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class ListImages
extends Operation {
    private String path = "/dsmcontroller/admin/namespaces/{namespace}/images";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String q;
    private String sortBy;
    private String sortDirection;
    private Integer count;
    private Integer offset;

    @Deprecated
    public ListImages(String namespace, String q, String sortBy, String sortDirection, Integer count, Integer offset) {
        this.namespace = namespace;
        this.q = q;
        this.sortBy = sortBy;
        this.sortDirection = sortDirection;
        this.count = count;
        this.offset = offset;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("q", this.q == null ? null : Arrays.asList(this.q));
        queryParams.put("sortBy", this.sortBy == null ? null : Arrays.asList(this.sortBy));
        queryParams.put("sortDirection", this.sortDirection == null ? null : Arrays.asList(this.sortDirection));
        queryParams.put("count", this.count == null ? null : Arrays.asList(String.valueOf(this.count)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.count == null) {
            return false;
        }
        return this.offset != null;
    }

    public ModelsListImageResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsListImageResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("q", "None");
        result.put("sortBy", "None");
        result.put("sortDirection", "None");
        result.put("count", "None");
        result.put("offset", "None");
        return result;
    }

    public static ListImagesBuilder builder() {
        return new ListImagesBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getQ() {
        return this.q;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public String getSortDirection() {
        return this.sortDirection;
    }

    public Integer getCount() {
        return this.count;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public void setSortDirection(String sortDirection) {
        this.sortDirection = sortDirection;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public static class ListImagesBuilder {
        private String namespace;
        private String q;
        private Integer count;
        private Integer offset;
        private String sortBy;
        private String sortDirection;

        public ListImagesBuilder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public ListImagesBuilder sortByFromEnum(SortBy sortBy) {
            this.sortBy = sortBy.toString();
            return this;
        }

        public ListImagesBuilder sortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        public ListImagesBuilder sortDirectionFromEnum(SortDirection sortDirection) {
            this.sortDirection = sortDirection.toString();
            return this;
        }

        ListImagesBuilder() {
        }

        public ListImagesBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ListImagesBuilder q(String q) {
            this.q = q;
            return this;
        }

        public ListImagesBuilder count(Integer count) {
            this.count = count;
            return this;
        }

        public ListImagesBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public ListImages build() {
            return new ListImages(this.namespace, this.q, this.sortBy, this.sortDirection, this.count, this.offset);
        }

        public String toString() {
            return "ListImages.ListImagesBuilder(namespace=" + this.namespace + ", q=" + this.q + ", sortBy=" + this.sortBy + ", sortDirection=" + this.sortDirection + ", count=" + this.count + ", offset=" + this.offset + ")";
        }
    }

    public static enum SortDirection {
        Asc("asc"),
        Desc("desc");

        private String value;

        private SortDirection(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum SortBy {
        CreatedAt("createdAt"),
        UpdatedAt("updatedAt"),
        Version("version");

        private String value;

        private SortBy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

