/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.dsmc.operations.image_config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.dsmc.models.ModelsGetImageDetailResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class ImageDetailClient
extends Operation {
    private String path = "/dsmcontroller/namespaces/{namespace}/images/versions/{version}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String version;

    @Deprecated
    public ImageDetailClient(String namespace, String version) {
        this.namespace = namespace;
        this.version = version;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.version != null) {
            pathParams.put("version", this.version);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.version != null;
    }

    public ModelsGetImageDetailResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsGetImageDetailResponse().createFromJson(json);
    }

    public static ImageDetailClientBuilder builder() {
        return new ImageDetailClientBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getVersion() {
        return this.version;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public static class ImageDetailClientBuilder {
        private String namespace;
        private String version;

        ImageDetailClientBuilder() {
        }

        public ImageDetailClientBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ImageDetailClientBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ImageDetailClient build() {
            return new ImageDetailClient(this.namespace, this.version);
        }

        public String toString() {
            return "ImageDetailClient.ImageDetailClientBuilder(namespace=" + this.namespace + ", version=" + this.version + ")";
        }
    }
}

