/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.dsmc.operations.image_config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class DeleteImage
extends Operation {
    private String path = "/dsmcontroller/admin/namespaces/{namespace}/images";
    private String method = "DELETE";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String imageURI;
    private String version;

    @Deprecated
    public DeleteImage(String namespace, String imageURI, String version) {
        this.namespace = namespace;
        this.imageURI = imageURI;
        this.version = version;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("imageURI", this.imageURI == null ? null : Arrays.asList(this.imageURI));
        queryParams.put("version", this.version == null ? null : Arrays.asList(this.version));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.imageURI == null) {
            return false;
        }
        return this.version != null;
    }

    public void handleEmptyResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 204) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("imageURI", "None");
        result.put("version", "None");
        return result;
    }

    public static DeleteImageBuilder builder() {
        return new DeleteImageBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getImageURI() {
        return this.imageURI;
    }

    public String getVersion() {
        return this.version;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setImageURI(String imageURI) {
        this.imageURI = imageURI;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public static class DeleteImageBuilder {
        private String namespace;
        private String imageURI;
        private String version;

        DeleteImageBuilder() {
        }

        public DeleteImageBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public DeleteImageBuilder imageURI(String imageURI) {
            this.imageURI = imageURI;
            return this;
        }

        public DeleteImageBuilder version(String version) {
            this.version = version;
            return this;
        }

        public DeleteImage build() {
            return new DeleteImage(this.namespace, this.imageURI, this.version);
        }

        public String toString() {
            return "DeleteImage.DeleteImageBuilder(namespace=" + this.namespace + ", imageURI=" + this.imageURI + ", version=" + this.version + ")";
        }
    }
}

