/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.dsmc.operations.deployment_config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.dsmc.models.ModelsDeploymentWithOverride;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetDeployment
extends Operation {
    private String path = "/dsmcontroller/admin/namespaces/{namespace}/configs/deployments/{deployment}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String deployment;
    private String namespace;

    @Deprecated
    public GetDeployment(String deployment, String namespace) {
        this.deployment = deployment;
        this.namespace = namespace;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.deployment != null) {
            pathParams.put("deployment", this.deployment);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.deployment == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ModelsDeploymentWithOverride parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsDeploymentWithOverride().createFromJson(json);
    }

    public static GetDeploymentBuilder builder() {
        return new GetDeploymentBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getDeployment() {
        return this.deployment;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setDeployment(String deployment) {
        this.deployment = deployment;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public static class GetDeploymentBuilder {
        private String deployment;
        private String namespace;

        GetDeploymentBuilder() {
        }

        public GetDeploymentBuilder deployment(String deployment) {
            this.deployment = deployment;
            return this;
        }

        public GetDeploymentBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetDeployment build() {
            return new GetDeployment(this.deployment, this.namespace);
        }

        public String toString() {
            return "GetDeployment.GetDeploymentBuilder(deployment=" + this.deployment + ", namespace=" + this.namespace + ")";
        }
    }
}

