/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.dsmc.operations.deployment_config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.dsmc.models.ModelsCreateDeploymentOverrideRequest;
import net.accelbyte.sdk.api.dsmc.models.ModelsDeploymentWithOverride;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class CreateDeploymentOverride
extends Operation {
    private String path = "/dsmcontroller/admin/namespaces/{namespace}/configs/deployments/{deployment}/overrides/version/{version}";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String deployment;
    private String namespace;
    private String version;
    private ModelsCreateDeploymentOverrideRequest body;

    @Deprecated
    public CreateDeploymentOverride(String deployment, String namespace, String version, ModelsCreateDeploymentOverrideRequest body) {
        this.deployment = deployment;
        this.namespace = namespace;
        this.version = version;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.deployment != null) {
            pathParams.put("deployment", this.deployment);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.version != null) {
            pathParams.put("version", this.version);
        }
        return pathParams;
    }

    public ModelsCreateDeploymentOverrideRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.deployment == null) {
            return false;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.version != null;
    }

    public ModelsDeploymentWithOverride parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 201) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsDeploymentWithOverride().createFromJson(json);
    }

    public static CreateDeploymentOverrideBuilder builder() {
        return new CreateDeploymentOverrideBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getDeployment() {
        return this.deployment;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getVersion() {
        return this.version;
    }

    public ModelsCreateDeploymentOverrideRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setDeployment(String deployment) {
        this.deployment = deployment;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setBody(ModelsCreateDeploymentOverrideRequest body) {
        this.body = body;
    }

    public static class CreateDeploymentOverrideBuilder {
        private String deployment;
        private String namespace;
        private String version;
        private ModelsCreateDeploymentOverrideRequest body;

        CreateDeploymentOverrideBuilder() {
        }

        public CreateDeploymentOverrideBuilder deployment(String deployment) {
            this.deployment = deployment;
            return this;
        }

        public CreateDeploymentOverrideBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public CreateDeploymentOverrideBuilder version(String version) {
            this.version = version;
            return this;
        }

        public CreateDeploymentOverrideBuilder body(ModelsCreateDeploymentOverrideRequest body) {
            this.body = body;
            return this;
        }

        public CreateDeploymentOverride build() {
            return new CreateDeploymentOverride(this.deployment, this.namespace, this.version, this.body);
        }

        public String toString() {
            return "CreateDeploymentOverride.CreateDeploymentOverrideBuilder(deployment=" + this.deployment + ", namespace=" + this.namespace + ", version=" + this.version + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

