/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.dsmc.operations.deployment_config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.dsmc.models.ModelsCreateDeploymentRequest;
import net.accelbyte.sdk.api.dsmc.models.ModelsDeploymentWithOverride;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class CreateDeploymentClient
extends Operation {
    private String path = "/dsmcontroller/namespaces/{namespace}/configs/deployments/{deployment}";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String deployment;
    private String namespace;
    private ModelsCreateDeploymentRequest body;

    @Deprecated
    public CreateDeploymentClient(String deployment, String namespace, ModelsCreateDeploymentRequest body) {
        this.deployment = deployment;
        this.namespace = namespace;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.deployment != null) {
            pathParams.put("deployment", this.deployment);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public ModelsCreateDeploymentRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.deployment == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ModelsDeploymentWithOverride parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 201) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsDeploymentWithOverride().createFromJson(json);
    }

    public static CreateDeploymentClientBuilder builder() {
        return new CreateDeploymentClientBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getDeployment() {
        return this.deployment;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ModelsCreateDeploymentRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setDeployment(String deployment) {
        this.deployment = deployment;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(ModelsCreateDeploymentRequest body) {
        this.body = body;
    }

    public static class CreateDeploymentClientBuilder {
        private String deployment;
        private String namespace;
        private ModelsCreateDeploymentRequest body;

        CreateDeploymentClientBuilder() {
        }

        public CreateDeploymentClientBuilder deployment(String deployment) {
            this.deployment = deployment;
            return this;
        }

        public CreateDeploymentClientBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public CreateDeploymentClientBuilder body(ModelsCreateDeploymentRequest body) {
            this.body = body;
            return this;
        }

        public CreateDeploymentClient build() {
            return new CreateDeploymentClient(this.deployment, this.namespace, this.body);
        }

        public String toString() {
            return "CreateDeploymentClient.CreateDeploymentClientBuilder(deployment=" + this.deployment + ", namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

