/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.dsmc.operations.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.dsmc.models.ModelsDSMConfigRecord;
import net.accelbyte.sdk.api.dsmc.models.ModelsUpdatePortRequest;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UpdatePort
extends Operation {
    private String path = "/dsmcontroller/admin/namespaces/{namespace}/configs/ports/{name}";
    private String method = "PATCH";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String name;
    private String namespace;
    private ModelsUpdatePortRequest body;

    @Deprecated
    public UpdatePort(String name, String namespace, ModelsUpdatePortRequest body) {
        this.name = name;
        this.namespace = namespace;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.name != null) {
            pathParams.put("name", this.name);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public ModelsUpdatePortRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.name == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ModelsDSMConfigRecord parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsDSMConfigRecord().createFromJson(json);
    }

    public static UpdatePortBuilder builder() {
        return new UpdatePortBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ModelsUpdatePortRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(ModelsUpdatePortRequest body) {
        this.body = body;
    }

    public static class UpdatePortBuilder {
        private String name;
        private String namespace;
        private ModelsUpdatePortRequest body;

        UpdatePortBuilder() {
        }

        public UpdatePortBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UpdatePortBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UpdatePortBuilder body(ModelsUpdatePortRequest body) {
            this.body = body;
            return this;
        }

        public UpdatePort build() {
            return new UpdatePort(this.name, this.namespace, this.body);
        }

        public String toString() {
            return "UpdatePort.UpdatePortBuilder(name=" + this.name + ", namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

