/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.dsmc.operations.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.dsmc.models.ModelsDSMConfigRecord;
import net.accelbyte.sdk.api.dsmc.models.ModelsUpdateDSMConfigRequest;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UpdateConfig
extends Operation {
    private String path = "/dsmcontroller/admin/namespaces/{namespace}/configs";
    private String method = "PATCH";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private ModelsUpdateDSMConfigRequest body;

    @Deprecated
    public UpdateConfig(String namespace, ModelsUpdateDSMConfigRequest body) {
        this.namespace = namespace;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public ModelsUpdateDSMConfigRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public ModelsDSMConfigRecord parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsDSMConfigRecord().createFromJson(json);
    }

    public static UpdateConfigBuilder builder() {
        return new UpdateConfigBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ModelsUpdateDSMConfigRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(ModelsUpdateDSMConfigRequest body) {
        this.body = body;
    }

    public static class UpdateConfigBuilder {
        private String namespace;
        private ModelsUpdateDSMConfigRequest body;

        UpdateConfigBuilder() {
        }

        public UpdateConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UpdateConfigBuilder body(ModelsUpdateDSMConfigRequest body) {
            this.body = body;
            return this;
        }

        public UpdateConfig build() {
            return new UpdateConfig(this.namespace, this.body);
        }

        public String toString() {
            return "UpdateConfig.UpdateConfigBuilder(namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

