/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.dsmc.operations.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.dsmc.models.ModelsImportResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class ImportConfigV1
extends Operation {
    private String path = "/dsmcontroller/admin/v1/namespaces/{namespace}/configs/import";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("multipart/form-data");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private File file;

    @Deprecated
    public ImportConfigV1(String namespace, File file) {
        this.namespace = namespace;
        this.file = file;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.file != null) {
            formDataParams.put("file", this.file);
        }
        return formDataParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public ModelsImportResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsImportResponse().createFromJson(json);
    }

    public static ImportConfigV1Builder builder() {
        return new ImportConfigV1Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public File getFile() {
        return this.file;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public static class ImportConfigV1Builder {
        private String namespace;
        private File file;

        ImportConfigV1Builder() {
        }

        public ImportConfigV1Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ImportConfigV1Builder file(File file) {
            this.file = file;
            return this;
        }

        public ImportConfigV1 build() {
            return new ImportConfigV1(this.namespace, this.file);
        }

        public String toString() {
            return "ImportConfigV1.ImportConfigV1Builder(namespace=" + this.namespace + ", file=" + this.file + ")";
        }
    }
}

