/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.dsmc.operations.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.dsmc.models.ModelsDSMConfigRecord;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class DeletePort
extends Operation {
    private String path = "/dsmcontroller/admin/namespaces/{namespace}/configs/ports/{name}";
    private String method = "DELETE";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String name;
    private String namespace;

    @Deprecated
    public DeletePort(String name, String namespace) {
        this.name = name;
        this.namespace = namespace;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.name != null) {
            pathParams.put("name", this.name);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.name == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ModelsDSMConfigRecord parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsDSMConfigRecord().createFromJson(json);
    }

    public static DeletePortBuilder builder() {
        return new DeletePortBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public static class DeletePortBuilder {
        private String name;
        private String namespace;

        DeletePortBuilder() {
        }

        public DeletePortBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DeletePortBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public DeletePort build() {
            return new DeletePort(this.name, this.namespace);
        }

        public String toString() {
            return "DeletePort.DeletePortBuilder(name=" + this.name + ", namespace=" + this.namespace + ")";
        }
    }
}

