/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.dsmc.operations.admin;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.dsmc.models.ModelsListSessionResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class ListSession
extends Operation {
    private String path = "/dsmcontroller/admin/namespaces/{namespace}/sessions";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String region;
    private Boolean withServer;
    private Integer count;
    private Integer offset;

    @Deprecated
    public ListSession(String namespace, String region, Boolean withServer, Integer count, Integer offset) {
        this.namespace = namespace;
        this.region = region;
        this.withServer = withServer;
        this.count = count;
        this.offset = offset;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("region", this.region == null ? null : Arrays.asList(this.region));
        queryParams.put("withServer", this.withServer == null ? null : Arrays.asList(String.valueOf(this.withServer)));
        queryParams.put("count", this.count == null ? null : Arrays.asList(String.valueOf(this.count)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.count == null) {
            return false;
        }
        return this.offset != null;
    }

    public ModelsListSessionResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsListSessionResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("region", "None");
        result.put("withServer", "None");
        result.put("count", "None");
        result.put("offset", "None");
        return result;
    }

    public static ListSessionBuilder builder() {
        return new ListSessionBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getRegion() {
        return this.region;
    }

    public Boolean getWithServer() {
        return this.withServer;
    }

    public Integer getCount() {
        return this.count;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setWithServer(Boolean withServer) {
        this.withServer = withServer;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public static class ListSessionBuilder {
        private String namespace;
        private String region;
        private Boolean withServer;
        private Integer count;
        private Integer offset;

        ListSessionBuilder() {
        }

        public ListSessionBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ListSessionBuilder region(String region) {
            this.region = region;
            return this;
        }

        public ListSessionBuilder withServer(Boolean withServer) {
            this.withServer = withServer;
            return this;
        }

        public ListSessionBuilder count(Integer count) {
            this.count = count;
            return this;
        }

        public ListSessionBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public ListSession build() {
            return new ListSession(this.namespace, this.region, this.withServer, this.count, this.offset);
        }

        public String toString() {
            return "ListSession.ListSessionBuilder(namespace=" + this.namespace + ", region=" + this.region + ", withServer=" + this.withServer + ", count=" + this.count + ", offset=" + this.offset + ")";
        }
    }
}

