/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.dslogmanager.operations.terminated_servers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.dslogmanager.models.ModelsLogFileStatus;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class CheckServerLogs
extends Operation {
    private String path = "/dslogmanager/namespaces/{namespace}/servers/{podName}/logs/exists";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json", "text/x-log");
    private String locationQuery = null;
    private String namespace;
    private String podName;

    @Deprecated
    public CheckServerLogs(String namespace, String podName) {
        this.namespace = namespace;
        this.podName = podName;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.podName != null) {
            pathParams.put("podName", this.podName);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.podName != null;
    }

    public ModelsLogFileStatus parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsLogFileStatus().createFromJson(json);
    }

    public static CheckServerLogsBuilder builder() {
        return new CheckServerLogsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPodName() {
        return this.podName;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPodName(String podName) {
        this.podName = podName;
    }

    public static class CheckServerLogsBuilder {
        private String namespace;
        private String podName;

        CheckServerLogsBuilder() {
        }

        public CheckServerLogsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public CheckServerLogsBuilder podName(String podName) {
            this.podName = podName;
            return this;
        }

        public CheckServerLogs build() {
            return new CheckServerLogs(this.namespace, this.podName);
        }

        public String toString() {
            return "CheckServerLogs.CheckServerLogsBuilder(namespace=" + this.namespace + ", podName=" + this.podName + ")";
        }
    }
}

